% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ch_col_transparent}
\alias{ch_col_transparent}
\title{Adjusts colour codes to introduce transparency

\code{ch_col_transparent} is used to adjust colour codes to introduce transparency.}
\usage{
ch_col_transparent(colour, trans)
}
\arguments{
\item{colour}{Vector of colours you wish to add transparency to.}

\item{trans}{Integer(s) describing the degree of transparency, from ~200
(slightly transparent) to <10 (very transparent).}
}
\value{
\item{res}{returned updated colour code with transparency}
}
\description{
Adjusts colour codes to introduce transparency

\code{ch_col_transparent} is used to adjust colour codes to introduce transparency.
}
\examples{

# plot randomly distributed data
plot(rnorm(20),col='black')

# create a transparent blue colour for plotting
mycol <- ch_col_transparent('blue',100)

# plot more random points in transparent blue colour
points(rnorm(20),col=mycol)

# add transparency to multiple colours
ch_col_transparent( c('red','blue','green'), c(50,100,200))

}
\seealso{
See original code on post in Stack Overflow
\href{http://stackoverflow.com/questions/12995683/any-way-to-make-plot-points-in-scatterplot-more-transparent-in-rmaking}{
plot points transparent in R}
}
\keyword{colour}
\keyword{transparency}
