% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_RFSlope.R
\name{CST_RFSlope}
\alias{CST_RFSlope}
\title{RainFARM spectral slopes from a CSTools object}
\usage{
CST_RFSlope(data, kmin = 1, time_dim = NULL)
}
\arguments{
\item{data}{An object of the class 's2dv_cube', containing the spatial precipitation fields to downscale.
The data object is expected to have an element named \code{$data} with at least two
spatial dimensions named "lon" and "lat" and one or more dimensions over which
to average these slopes, which can be specified by parameter \code{time_dim}.}

\item{kmin}{First wavenumber for spectral slope (default \code{kmin=1}).}

\item{time_dim}{String or character array with name(s) of dimension(s) (e.g. "ftime", "sdate", "member" ...) 
over which to compute spectral slopes. If a character array of dimension names is provided, the spectral slopes
will be computed as an average over all elements belonging to those dimensions.
If omitted one of c("ftime", "sdate", "time")  is searched and the first one with more than one element is chosen.}
}
\value{
CST_RFSlope() returns spectral slopes using the RainFARM convention
(the logarithmic slope of k*|A(k)|^2 where A(k) are the spectral amplitudes).
The returned array has the same dimensions as the \code{exp} element of the input object,
minus the dimensions specified by \code{lon_dim}, \code{lat_dim} and \code{time_dim}.
}
\description{
This function computes spatial spectral slopes from a CSTools object
to be used for RainFARM stochastic precipitation downscaling method and accepts a CSTools object (of the class 's2dv_cube') as input.
}
\examples{
#Example using CST_RFSlope for a CSTools object
exp <- 1 : (2 * 3 * 4 * 8 * 8)
dim(exp) <- c(dataset = 1, member = 2, sdate = 3, ftime = 4, lat = 8, lon = 8)
lon <- seq(10, 13.5, 0.5)
dim(lon) <- c(lon = length(lon))
lat <- seq(40, 43.5, 0.5)
dim(lat) <- c(lat = length(lat))
data <- list(data = exp, lon = lon, lat = lat)
slopes <- CST_RFSlope(data)
dim(slopes)
# dataset  member   sdate
#       1       2       3 
slopes
#         [,1]     [,2]     [,3]
#[1,] 1.893503 1.893503 1.893503
#[2,] 1.893503 1.893503 1.893503
}
\author{
Jost von Hardenberg - ISAC-CNR, \email{j.vonhardenberg@isac.cnr.it}
}
