% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_method.r
\name{lm.cv}
\alias{lm.cv}
\title{Get a fitted model selected by cross validation}
\usage{
lm.cv(
  X,
  Y,
  intercept,
  fit.percent,
  num.repeat,
  method.names = NULL,
  num.core = 1,
  log.level = NULL
)
}
\arguments{
\item{X}{covariates (n times p matrix, n: number of entries, p: number of covariates)}

\item{Y}{response (vector with n entries)}

\item{intercept}{TRUE to fit the data with an intercept, FALSE to fit the data without an intercept}

\item{fit.percent}{percentage of observations used in fitting in cross validation. Each set of subsampling data will have (n times fit.percent) observations for fitting and n times (1-fit.percent) observations for calculating the mse}

\item{num.repeat}{number of sets of subsampling data used in cross validation}

\item{method.names}{vector of method names to be used in cross validation. Choose among "lasso", "elastic", "relaxo", "mcp" and "scad". Default is to use all methods listed above}

\item{num.core}{number of cores to use. Default is 1 (i.e. no parallel running)}

\item{log.level}{log level to set. Default is NULL, which means no change in log level. See the function CSUV::set.log.level for more details}
}
\value{
a list which includes the estimated coefficients (est.b) and the corresponding ordinary least square fit from stats::lm()
}
\description{
Get a fitted model selected by cross validation
}
\examples{
\donttest{
set.log.level(futile.logger::WARN)
X = matrix(rnorm(1000), nrow = 100)
Y = rowSums(X[,1:3])+rnorm(100)
cv.mod = lm.cv(X, Y, intercept = FALSE, fit.percent = 0.5, num.repeat = 50)
print(cv.mod$est.b)
}
}
