% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/effecube.R
\name{effecube}
\alias{effecube}
\title{Auxiliary function for the log-likelihood estimation of CUBE models without covariates}
\usage{
effecube(paravec, dati, m)
}
\arguments{
\item{paravec}{Vector of initial estimates for the feeling and the overdispersion parameters}

\item{dati}{Matrix binding together a column vector of length \eqn{m} containing the posterior
probabilities that each observed category has been generated by the first component distribution
of the mixture, and the column vector of the absolute frequencies of the observations}
}
\description{
Define the opposite of the scalar function that is maximized when running the E-M
algorithm for CUBE models without covariates.
}
\details{
It is called as an argument for optim within CUBE function (where no covariate is specified)
 and "cubeforsim" as the function to minimize.
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
 \emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr
}
\keyword{internal}

