% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{diff,Expression-method}
\alias{diff,Expression-method}
\alias{diff}
\title{Lagged and Iterated Differences}
\usage{
\S4method{diff}{Expression}(x, lag = 1, differences = 1, ...)
}
\arguments{
\item{x}{An \linkS4class{Expression}.}

\item{lag}{An integer indicating which lag to use.}

\item{differences}{An integer indicating the order of the difference.}

\item{...}{(Optional) Addition \code{axis} argument, specifying the dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{axis = 1}.}
}
\value{
An \linkS4class{Expression} representing the \code{k}th order difference.
}
\description{
The lagged and iterated differences of a vector.
If \code{x} is length \code{n}, this function returns a length \eqn{n-k} vector of the \eqn{k}th order difference between the lagged terms.
\code{diff(x)} returns the vector of differences between adjacent elements in the vector, i.e. [x[2] - x[1], x[3] - x[2], ...].
\code{diff(x,1,2)} is the second-order differences vector, equivalently diff(diff(x)). \code{diff(x,1,0)} returns the vector x unchanged.
\code{diff(x,2)} returns the vector of differences [x[3] - x[1], x[4] - x[2], ...], equivalent to \code{x[(1+lag):n] - x[1:(n-lag)]}.
}
\examples{
## Problem data
m <- 101
L <- 2
h <- L/(m-1)

## Form objective and constraints
x <- Variable(m)
y <- Variable(m)
obj <- sum(y)
constr <- list(x[1] == 0, y[1] == 1, x[m] == 1, y[m] == 1, diff(x)^2 + diff(y)^2 <= h^2)

## Solve the catenary problem
prob <- Problem(Minimize(obj), constr)
result <- solve(prob)

## Plot and compare with ideal catenary
xs <- result$getValue(x)
ys <- result$getValue(y)
plot(c(0, 1), c(0, 1), type = 'n', xlab = "x", ylab = "y")
lines(xs, ys, col = "blue", lwd = 2)
grid()
}
