% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gurobi-solver.R
\docType{class}
\name{GUROBI-class}
\alias{GUROBI-class}
\alias{GUROBI}
\alias{GUROBI}
\alias{lp_capable,GUROBI-method}
\alias{socp_capable,GUROBI-method}
\alias{sdp_capable,GUROBI-method}
\alias{exp_capable,GUROBI-method}
\alias{mip_capable,GUROBI-method}
\alias{name,GUROBI-method}
\alias{import_solver,GUROBI-method}
\alias{Solver.solve,GUROBI-method}
\title{The GUROBI class.}
\usage{
GUROBI()

\S4method{lp_capable}{GUROBI}(solver)

\S4method{socp_capable}{GUROBI}(solver)

\S4method{sdp_capable}{GUROBI}(solver)

\S4method{exp_capable}{GUROBI}(solver)

\S4method{mip_capable}{GUROBI}(solver)

\S4method{name}{GUROBI}(object)

\S4method{import_solver}{GUROBI}(solver)

\S4method{Solver.solve}{GUROBI}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)
}
\arguments{
\item{object, solver}{A \linkS4class{GUROBI} object.}

\item{objective}{A list representing the canonicalized objective.}

\item{constraints}{A list of canonicalized constraints.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}
}
\description{
This class is an interface for the commercial GUROBI solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{lp_capable}: GUROBI can handle linear programs.

\item \code{socp_capable}: GUROBI can handle second-order cone programs.

\item \code{sdp_capable}: GUROBI cannot handle semidefinite programs.

\item \code{exp_capable}: GUROBI cannot handle exponential cone programs.

\item \code{mip_capable}: GUROBI can handle mixed-integer programs.

\item \code{name}: The name of the solver.

\item \code{import_solver}: Imports the reticulate library to use the python solver.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.
}}

\references{
\emph{Gurobi optimizer reference manual version 5.0,} Gurobi Optimization, Inc., Houston, Texas, July 2012.
}
\seealso{
the \href{http://www.gurobi.com/documentation/7.5/refman/r_api_overview.html}{GUROBI Official Site}.
}
