% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{GLPK-class}
\alias{GLPK-class}
\alias{GLPK}
\alias{mip_capable,GLPK-method}
\alias{status_map,GLPK-method}
\alias{name,GLPK-method}
\alias{import_solver,GLPK-method}
\alias{invert,GLPK,list,list-method}
\alias{solve_via_data,GLPK-method}
\title{An interface for the GLPK solver.}
\usage{
GLPK()

\S4method{mip_capable}{GLPK}(solver)

\S4method{status_map}{GLPK}(solver, status)

\S4method{name}{GLPK}(x)

\S4method{import_solver}{GLPK}(solver)

\S4method{invert}{GLPK,list,list}(object, solution, inverse_data)

\S4method{solve_via_data}{GLPK}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{GLPK} object.}

\item{status}{A status code returned by the solver.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the GLPK solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable}: Can the solver handle mixed-integer programs?

\item \code{status_map}: Converts status returned by the GLPK solver to its respective CVXPY status.

\item \code{name}: Returns the name of the solver.

\item \code{import_solver}: Imports the solver.

\item \code{invert}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.
}}

