% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Power-class}
\alias{Power-class}
\alias{.Power}
\alias{Power}
\alias{to_numeric,Power-method}
\alias{sign_from_args,Power-method}
\alias{is_atom_convex,Power-method}
\alias{is_atom_concave,Power-method}
\alias{is_atom_log_log_convex,Power-method}
\alias{is_atom_log_log_concave,Power-method}
\alias{is_constant,Power-method}
\alias{is_incr,Power-method}
\alias{is_decr,Power-method}
\alias{is_quadratic,Power-method}
\alias{is_qpwa,Power-method}
\alias{.grad,Power-method}
\alias{.domain,Power-method}
\alias{get_data,Power-method}
\alias{copy,Power-method}
\alias{name,Power-method}
\title{The Power class.}
\usage{
Power(x, p, max_denom = 1024)

\S4method{to_numeric}{Power}(object, values)

\S4method{sign_from_args}{Power}(object)

\S4method{is_atom_convex}{Power}(object)

\S4method{is_atom_concave}{Power}(object)

\S4method{is_atom_log_log_convex}{Power}(object)

\S4method{is_atom_log_log_concave}{Power}(object)

\S4method{is_constant}{Power}(object)

\S4method{is_incr}{Power}(object, idx)

\S4method{is_decr}{Power}(object, idx)

\S4method{is_quadratic}{Power}(object)

\S4method{is_qpwa}{Power}(object)

\S4method{.grad}{Power}(object, values)

\S4method{.domain}{Power}(object)

\S4method{get_data}{Power}(object)

\S4method{copy}{Power}(object, args = NULL, id_objects = list())

\S4method{name}{Power}(x)
}
\arguments{
\item{x}{The \linkS4class{Expression} to be raised to a power.}

\item{p}{A numeric value indicating the scalar power.}

\item{max_denom}{The maximum denominator considered in forming a rational approximation of \code{p}.}

\item{object}{A \linkS4class{Power} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}

\item{args}{A list of arguments to reconstruct the atom. If args=NULL, use the current args of the atom}

\item{id_objects}{Currently unused.}
}
\description{
This class represents the elementwise power function \eqn{f(x) = x^p}.
If \code{expr} is a CVXR expression, then \code{expr^p} is equivalent to \code{Power(expr, p)}.
}
\details{
For \eqn{p = 0}, \eqn{f(x) = 1}, constant, positive.

For \eqn{p = 1}, \eqn{f(x) = x}, affine, increasing, same sign as \eqn{x}.

For \eqn{p = 2,4,8,...}, \eqn{f(x) = |x|^p}, convex, signed monotonicity, positive.

For \eqn{p < 0} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x > 0}}
  \item{\eqn{+\infty}}{\eqn{x \leq 0}}
}, this function is convex, decreasing, and positive.

For \eqn{0 < p < 1} and \eqn{f(x) =}
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{-\infty}}{\eqn{x < 0}}
}, this function is concave, increasing, and positive.

For \eqn{p > 1, p \neq 2,4,8,\ldots} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{+\infty}}{\eqn{x < 0}}
}, this function is convex, increasing, and positive.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: Throw an error if the power is negative and cannot be handled.

\item \code{sign_from_args}: The sign of the atom.

\item \code{is_atom_convex}: Is \eqn{p \leq 0} or \eqn{p \geq 1}?

\item \code{is_atom_concave}: Is \eqn{p \geq 0} or \eqn{p \leq 1}?

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{is_constant}: A logical value indicating whether the atom is constant.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing.

\item \code{is_quadratic}: A logical value indicating whether the atom is quadratic.

\item \code{is_qpwa}: A logical value indicating whether the atom is quadratic of piecewise affine.

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.domain}: Returns constraints describng the domain of the node

\item \code{get_data}: A list containing the output of \code{pow_low, pow_mid}, or \code{pow_high} depending on the input power.

\item \code{copy}: Returns a shallow  copy of the power atom

\item \code{name}: Returns the expression in string form.
}}

\section{Slots}{

\describe{
\item{\code{x}}{The \linkS4class{Expression} to be raised to a power.}

\item{\code{p}}{A numeric value indicating the scalar power.}

\item{\code{max_denom}}{The maximum denominator considered in forming a rational approximation of \code{p}.}
}}

