% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R
\docType{class}
\name{Expression-class}
\alias{Expression-class}
\alias{Expression}
\alias{value,Expression-method}
\alias{grad,Expression-method}
\alias{domain,Expression-method}
\alias{as.character,Expression-method}
\alias{name,Expression-method}
\alias{expr,Expression-method}
\alias{is_constant,Expression-method}
\alias{is_affine,Expression-method}
\alias{is_convex,Expression-method}
\alias{is_concave,Expression-method}
\alias{is_dcp,Expression-method}
\alias{is_log_log_constant,Expression-method}
\alias{is_log_log_affine,Expression-method}
\alias{is_log_log_convex,Expression-method}
\alias{is_log_log_concave,Expression-method}
\alias{is_dgp,Expression-method}
\alias{is_hermitian,Expression-method}
\alias{is_psd,Expression-method}
\alias{is_nsd,Expression-method}
\alias{is_quadratic,Expression-method}
\alias{is_symmetric,Expression-method}
\alias{is_pwl,Expression-method}
\alias{is_qpwa,Expression-method}
\alias{is_zero,Expression-method}
\alias{is_nonneg,Expression-method}
\alias{is_nonpos,Expression-method}
\alias{dim,Expression-method}
\alias{is_real,Expression-method}
\alias{is_imag,Expression-method}
\alias{is_complex,Expression-method}
\alias{size,Expression-method}
\alias{ndim,Expression-method}
\alias{flatten,Expression-method}
\alias{is_scalar,Expression-method}
\alias{is_vector,Expression-method}
\alias{is_matrix,Expression-method}
\alias{nrow,Expression-method}
\alias{ncol,Expression-method}
\title{The Expression class.}
\usage{
\S4method{value}{Expression}(object)

\S4method{grad}{Expression}(object)

\S4method{domain}{Expression}(object)

\S4method{as.character}{Expression}(x)

\S4method{name}{Expression}(x)

\S4method{expr}{Expression}(object)

\S4method{is_constant}{Expression}(object)

\S4method{is_affine}{Expression}(object)

\S4method{is_convex}{Expression}(object)

\S4method{is_concave}{Expression}(object)

\S4method{is_dcp}{Expression}(object)

\S4method{is_log_log_constant}{Expression}(object)

\S4method{is_log_log_affine}{Expression}(object)

\S4method{is_log_log_convex}{Expression}(object)

\S4method{is_log_log_concave}{Expression}(object)

\S4method{is_dgp}{Expression}(object)

\S4method{is_hermitian}{Expression}(object)

\S4method{is_psd}{Expression}(object)

\S4method{is_nsd}{Expression}(object)

\S4method{is_quadratic}{Expression}(object)

\S4method{is_symmetric}{Expression}(object)

\S4method{is_pwl}{Expression}(object)

\S4method{is_qpwa}{Expression}(object)

\S4method{is_zero}{Expression}(object)

\S4method{is_nonneg}{Expression}(object)

\S4method{is_nonpos}{Expression}(object)

\S4method{dim}{Expression}(x)

\S4method{is_real}{Expression}(object)

\S4method{is_imag}{Expression}(object)

\S4method{is_complex}{Expression}(object)

\S4method{size}{Expression}(object)

\S4method{ndim}{Expression}(object)

\S4method{flatten}{Expression}(object)

\S4method{is_scalar}{Expression}(object)

\S4method{is_vector}{Expression}(object)

\S4method{is_matrix}{Expression}(object)

\S4method{nrow}{Expression}(x)

\S4method{ncol}{Expression}(x)
}
\arguments{
\item{x, object}{An \linkS4class{Expression} object.}
}
\description{
This class represents a mathematical expression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{value(Expression)}: The value of the expression.

\item \code{grad(Expression)}: The (sub/super)-gradient of the expression with respect to each variable.

\item \code{domain(Expression)}: A list of constraints describing the closure of the region where the expression is finite.

\item \code{as.character(Expression)}: The string representation of the expression.

\item \code{name(Expression)}: The name of the expression.

\item \code{expr(Expression)}: The expression itself.

\item \code{is_constant(Expression)}: The expression is constant if it contains no variables or is identically zero.

\item \code{is_affine(Expression)}: The expression is affine if it is constant or both convex and concave.

\item \code{is_convex(Expression)}: A logical value indicating whether the expression is convex.

\item \code{is_concave(Expression)}: A logical value indicating whether the expression is concave.

\item \code{is_dcp(Expression)}: The expression is DCP if it is convex or concave.

\item \code{is_log_log_constant(Expression)}: Is the expression log-log constant, i.e., elementwise positive?

\item \code{is_log_log_affine(Expression)}: Is the expression log-log affine?

\item \code{is_log_log_convex(Expression)}: Is the expression log-log convex?

\item \code{is_log_log_concave(Expression)}: Is the expression log-log concave?

\item \code{is_dgp(Expression)}: The expression is DGP if it is log-log DCP.

\item \code{is_hermitian(Expression)}: A logical value indicating whether the expression is a Hermitian matrix.

\item \code{is_psd(Expression)}: A logical value indicating whether the expression is a positive semidefinite matrix.

\item \code{is_nsd(Expression)}: A logical value indicating whether the expression is a negative semidefinite matrix.

\item \code{is_quadratic(Expression)}: A logical value indicating whether the expression is quadratic.

\item \code{is_symmetric(Expression)}: A logical value indicating whether the expression is symmetric.

\item \code{is_pwl(Expression)}: A logical value indicating whether the expression is piecewise linear.

\item \code{is_qpwa(Expression)}: A logical value indicating whether the expression is quadratic of piecewise affine.

\item \code{is_zero(Expression)}: The expression is zero if it is both nonnegative and nonpositive.

\item \code{is_nonneg(Expression)}: A logical value indicating whether the expression is nonnegative.

\item \code{is_nonpos(Expression)}: A logical value indicating whether the expression is nonpositive.

\item \code{dim(Expression)}: The \code{c(row, col)} dimensions of the expression.

\item \code{is_real(Expression)}: A logical value indicating whether the expression is real.

\item \code{is_imag(Expression)}: A logical value indicating whether the expression is imaginary.

\item \code{is_complex(Expression)}: A logical value indicating whether the expression is complex.

\item \code{size(Expression)}: The number of entries in the expression.

\item \code{ndim(Expression)}: The number of dimensions of the expression.

\item \code{flatten(Expression)}: Vectorizes the expression.

\item \code{is_scalar(Expression)}: A logical value indicating whether the expression is a scalar.

\item \code{is_vector(Expression)}: A logical value indicating whether the expression is a row or column vector.

\item \code{is_matrix(Expression)}: A logical value indicating whether the expression is a matrix.

\item \code{nrow(Expression)}: Number of rows in the expression.

\item \code{ncol(Expression)}: Number of columns in the expression.

}}
