% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{Variable-class}
\alias{Variable-class}
\alias{.Variable}
\alias{Variable}
\alias{as.character,Variable-method}
\alias{name,Variable-method}
\alias{value,Variable-method}
\alias{grad,Variable-method}
\alias{variables,Variable-method}
\alias{canonicalize,Variable-method}
\title{The Variable class.}
\usage{
Variable(rows = NULL, cols = NULL, name = NA_character_, ...)

\S4method{as.character}{Variable}(x)

\S4method{name}{Variable}(x)

\S4method{value}{Variable}(object)

\S4method{grad}{Variable}(object)

\S4method{variables}{Variable}(object)

\S4method{canonicalize}{Variable}(object)
}
\arguments{
\item{rows}{The number of rows in the variable.}

\item{cols}{The number of columns in the variable.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{...}{(Optional) Additional attribute arguments. See \linkS4class{Leaf} for details.}

\item{x, object}{A \linkS4class{Variable} object.}
}
\description{
This class represents an optimization variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name}: The name of the variable.

\item \code{value}: Get the value of the variable.

\item \code{grad}: The sub/super-gradient of the variable represented as a sparse matrix.

\item \code{variables}: Returns itself as a variable.

\item \code{canonicalize}: The canonical form of the variable.
}}

\section{Slots}{

\describe{
\item{\code{dim}}{The dimensions of the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}
}}

\examples{
x <- Variable(3, name = "x0") ## 3-int variable
y <- Variable(3, 3, name = "y0") # Matrix variable
as.character(y)
id(y)
is_nonneg(x)
is_nonpos(x)
size(y)
name(y)
value(y) <- matrix(1:9, nrow = 3)
value(y)
grad(y)
variables(y)
canonicalize(y)
}
