% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{OneMinusPos-class}
\alias{OneMinusPos-class}
\alias{.OneMinusPos}
\alias{OneMinusPos}
\alias{name,OneMinusPos-method}
\alias{to_numeric,OneMinusPos-method}
\alias{dim_from_args,OneMinusPos-method}
\alias{sign_from_args,OneMinusPos-method}
\alias{is_atom_convex,OneMinusPos-method}
\alias{is_atom_concave,OneMinusPos-method}
\alias{is_atom_log_log_convex,OneMinusPos-method}
\alias{is_atom_log_log_concave,OneMinusPos-method}
\alias{is_incr,OneMinusPos-method}
\alias{is_decr,OneMinusPos-method}
\alias{.grad,OneMinusPos-method}
\title{The OneMinusPos class.}
\usage{
OneMinusPos(x)

\S4method{name}{OneMinusPos}(x)

\S4method{to_numeric}{OneMinusPos}(object, values)

\S4method{dim_from_args}{OneMinusPos}(object)

\S4method{sign_from_args}{OneMinusPos}(object)

\S4method{is_atom_convex}{OneMinusPos}(object)

\S4method{is_atom_concave}{OneMinusPos}(object)

\S4method{is_atom_log_log_convex}{OneMinusPos}(object)

\S4method{is_atom_log_log_concave}{OneMinusPos}(object)

\S4method{is_incr}{OneMinusPos}(object, idx)

\S4method{is_decr}{OneMinusPos}(object, idx)

\S4method{.grad}{OneMinusPos}(object, values)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{OneMinusPos} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the difference \eqn{1 - x} with domain \eqn{\{x : 0 < x < 1}\}
}
\section{Methods (by generic)}{
\itemize{
\item \code{name}: The name and arguments of the atom.

\item \code{to_numeric}: Returns one minus the value.

\item \code{dim_from_args}: The dimensions of the atom.

\item \code{sign_from_args}: Returns the sign (is positive, is negative) of the atom.

\item \code{is_atom_convex}: Is the atom convex?

\item \code{is_atom_concave}: Is the atom concave?

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{is_incr}: Is the atom weakly increasing in the argument \code{idx}?

\item \code{is_decr}: Is the atom weakly decreasing in the argument \code{idx}?

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric matrix.}
}}

