## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(CaMeA)

## ----eval = FALSE-------------------------------------------------------------
# install.packages("CaMeA")

## ----eval = FALSE-------------------------------------------------------------
# devtools::install_github("cberenfeld/camea", build_vignettes = TRUE)

## ----eval = FALSE-------------------------------------------------------------
# Rscript build_package.R

## -----------------------------------------------------------------------------
require(CaMeA)

# Example 1: With vectors of total numbers and events in treated and control

# Generate data
n <- 10

treated_total <- sample.int(1000, n)
control_total <- sample.int(1000, n)
treated_events <- rbinom(n,treated_total,0.5)
control_events <- rbinom(n,control_total,0.5)

# Choose measure: RD
measure <- "RD"

# Apply function
result <- camea(measure = measure, ai = treated_events, n1i = treated_total,
                    ci = control_events, n2i = control_total)

# Example 2: With contingency tables entries in data.frame format

# Generate data
n <- 10

treated_total <- sample.int(1000, n)
control_total <- sample.int(1000, n)
treated_events <- rbinom(n,treated_total,0.5)
control_events <- rbinom(n,control_total,0.5)
treated_negatives <- treated_total - treated_events
control_negatives <- control_total - control_events

dat <- data.frame(treated_events,control_events,treated_negatives,control_negatives)

# Choose measure: log-OR
measure <- "OR"

# Apply function
result <- camea(measure = measure, ai = treated_events, bi = treated_negatives,
                    ci = control_events, di = control_negatives, data = dat, log.scale = TRUE)



## ----my-forest-plot, fig.width=9, fig.height=6, out.width='100%'--------------
# apply the same function but print the plot
result <- camea(measure = measure, ai = treated_events, n1i = treated_total,
                    ci = control_events, n2i = control_total, log.scale = TRUE, plot = TRUE)

## ----echo=FALSE---------------------------------------------------------------
if (requireNamespace("kableExtra", quietly = TRUE)) {
  library(kableExtra)
}

df <- data.frame(Cat = c("A=1","A=0"),
                 "Y=1" = c("$n_{11}(k)$","$n_{10}(k)$"),
                 "Y=0" = c("$n_{01}(k)$","$n_{00}(k)$"))
kable(df, col.names = c("","Y=1","Y=0"), escape = F) %>% kable_styling(latex_options = "hold_position")


## ----metafor, eval = FALSE----------------------------------------------------
# # Create forest plot with single study results
# metafor::forest(x = results$thetai, ci.lb = results$ci.lb, ci.ub = results$ci.ub,
#                 header = c("Study",paste(measure_name,"[95% CI]")), top=2,
#                 ylim=c(-2, n_study+2), refline = refline, cex = 0.8)
# 
# # Computation of random-effects analysis and display in forest plot, if
# # option "random.effects = TRUE"
# dat <- metafor::escalc(measure=measure, ai=ai_vals, n1i=n1i_vals, ci=ci_vals,
#                        n2i=n2i_vals, data=dat)
# metafor::addpoly(res_random_effects, row = -1, mlab="Random-effects model", cex = 0.8)
# 
# # Display causal-meta analysis in forest plot
# res <- metafor::rma(yi = result$estimate, sei = result$se, method="FE")
# metafor::addpoly(res, row = 0, mlab="Causal meta-analysis", cex = 0.8)

