#' A Reference Class to generates differents \code{prediction.class} objects
#'
#' @description See the function \code{\link{prediction}} which produces an instance of this class
#' This class comes with a set of methods, some of them being useful for the user:
#' See the documentation for \code{\link{prediction}}... Other methods
#' should not be called as they are designed to be used during the calibration process.
#'
#' Fields should not be changed or manipulated by the user as they are updated internally
#' during the estimation process.
#' @field modelfit a \code{\link{calibrate.class}} object generated by \code{\link{calibrate}}
#' @field x.new a new data set (according to the data set used for calibration)
#' @field lowerPred the lower bound of the 90\% credibility interval
#' @field upperPred the upper bound of the 90\% credibility interval
#' @field meanPred the predicted value
#' @export
prediction.class <- R6Class(classname = "predict.class",
                           public = list(
                             modelfit = NULL,
                             x.new     = NULL,
                             lowerPred = NULL,
                             upperPred = NULL,
                             meanPred  = NULL,
                             initialize = function(modelfit,x.new)
                             {
                               self$modelfit    <- modelfit
                               self$x.new       <- x.new
                               self$checkNewdata(x.new)
                               self$predictCal()
                             },
                             predictCal = function()
                             {
                               Dim <- length(self$modelfit$pr)
                               if (is.matrix(self$modelfit$md$X)==TRUE)
                                 {
                                  l <- nrow(self$x.new)
                                 } else
                                 {
                                  l <- length(self$x.new)
                                 }
                               MAP  <- self$modelfit$output$MAP
                               COV  <- cov(self$modelfit$output$out$THETA[-c(1:self$modelfit$opt.estim$burnIn),])
                               samp <- mvrnorm(100,MAP,COV)
                               res  <- matrix(nr=100,nc=l)
                               if (self$modelfit$md$model=="model1" || self$modelfit$md$model=="model2")
                               {
                                 for (i in 1:100)
                                 {
                                   res[i,] <- self$modelfit$md$pred(samp[i,1:(Dim-1)],samp[i,Dim],self$x.new)$y
                                 }
                               }else
                               {
                                 for (i in 1:100)
                                 {
                                   res[i,] <- self$modelfit$md$fun(samp[i,1:(Dim-3)],samp[i,(Dim-2):(Dim-1)],samp[i,Dim],self$x.new)$y
                                 }
                               }
                               self$lowerPred <- apply(res,2,quantile,probs=0.05)
                               self$upperPred <- apply(res,2,quantile,probs=0.95)
                               self$meanPred  <- apply(res,2,quantile,probs=0.5)
                               self$print()
                             },
                             print = function()
                               {
                                 cat("Call:\n")
                                 print(self$modelfit$md$model)
                                 cat("\n")
                                 cat("With the function:\n")
                                 print(self$modelfit$md$code)
                                 cat("\n")
                                 cat("MAP estimator:\n")
                                 print(round(self$modelfit$output$MAP,5))
                               },
                             plot = function(select.X=NULL,rdata=NULL)
                             {
                               if (is.null(rdata)==TRUE)
                               {
                                 if (is.null(select.X)==TRUE)
                                 {
                                   ggdata <- data.frame(lower=self$lowerPred,upper=self$upperPred,x=self$x.new,
                                                        y=self$meanPred,fill="credibility interval at 90%",
                                                        type="predicted data")
                                 } else
                                 {
                                   ggdata <- data.frame(lower=self$lowerPred,upper=self$upperPred,x=select.X,
                                                        y=self$meanPred,fill="credibility interval at 90%",
                                                        type="predicted data")
                                 }
                                 p <- ggplot(ggdata)+geom_line(aes(y=y,x=x,col=type))+
                                   geom_ribbon(aes(ymin=lower, ymax=upper, x=x,fill=fill), alpha = 0.3)+
                                   theme_light()+xlab("")+ylab("")+
                                   scale_fill_manual("",values="blue4")+
                                   theme(legend.position=c(0.3,0.86),
                                         legend.text=element_text(face="bold",size = '20'),
                                         legend.title=element_blank(),
                                         legend.key=element_rect(colour=NA),
                                         axis.text=element_text(size=20))
                                 return(p)
                               } else
                               {
                                 if (is.null(select.X)==TRUE)
                                 {
                                   ggdata  <- data.frame(lower=self$lowerPred,upper=self$upperPred,x=self$x.new,
                                                        y=self$meanPred,type="predicted data"
                                                        ,fill="credibility interval at 90%")
                                   ggdata2 <- data.frame(lower=self$lowerPred,upper=self$upperPred,
                                                         x=self$x.new,y=rdata,type="real data",
                                                         fill="credibility interval at 90%")
                                   ggdata  <- rbind(ggdata,ggdata2)
                                 } else
                                 {
                                   ggdata  <- data.frame(lower=self$lowerPred,upper=self$upperPred,x=select.X,
                                                        y=self$meanPred,type="predicted data",
                                                        fill="credibility interval at 90%")
                                   ggdata2 <- data.frame(lower=self$lowerPred,upper=self$upperPred,x=select.X,
                                                         y=rdata,type="real data",
                                                         fill="credibility interval at 90%")
                                   ggdata  <- rbind(ggdata,ggdata2)
                                 }
                                 p <- ggplot(ggdata)+geom_line(aes(y=y,x=x,col=type))+
                                   geom_ribbon(aes(ymin=lower, ymax=upper, x=x,fill=fill), alpha = 0.3)+
                                   theme_light()+xlab("")+ylab("")+
                                   scale_fill_manual("",values="blue4")+
                                   theme(legend.position=c(0.3,0.86),
                                         legend.text=element_text(face="bold",size = '20'),
                                         legend.title=element_blank(),
                                         legend.key=element_rect(colour=NA),
                                         axis.text=element_text(size=20))
                                 return(p)
                               }

                              },
                             checkNewdata = function(x.new)
                             {
                               if (is.matrix(x.new)==TRUE)
                               {
                                 if (ncol(x.new)!=ncol(self$modelfit$md$X))
                                 {
                                   stop("Enter the same dimension for X")
                                 }
                               } else
                               {
                                 # if (length(x.new)!= length(self$modelfit$md$X))
                                 # {
                                 #   stop("Enter the same dimension for X")
                                 # }
                               }
                             }
                            ))



