% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chain}
\alias{chain}
\title{Return the MCMC chain in a \code{data.frame}}
\usage{
chain(modelfit, coda = TRUE)
}
\arguments{
\item{modelfit}{a \code{\link{calibrate.class}} object}

\item{coda}{if TRUE returns a coda object (if Nchains in opt.estim is higher than 1 a coda object
is automatically returned see \code{\link{codamenu}})}
}
\value{
return a \code{data.frame} or a coda object of the MCMC chain(s) generated.
}
\description{
\code{chain} is a function that returns a \code{data.frame} of calibration run without the burn-in
}
\examples{
\dontrun{
###################### The code to calibrate
X <- cbind(seq(0,1,length.out=10),seq(0,1,length.out=10))
code <- function(X,theta)
{
  return((6*X[,1]*theta[2]-2)^2*theta[1]*sin(theta[3]*X[,2]-4))
}
Yexp <- code(X,c(1,1,11))+rnorm(10,0,0.1)

############### For the first model
###### Definition of the model
md <- model(code,X,Yexp,"model1")
###### Definition of the prior densities
pr <- prior(type.prior=c("gaussian","gaussian","gaussian","gamma"),opt.prior=
list(c(1,0.01),c(1,0.01),c(11,3),c(2,0.1)))
###### Definition of the calibration options
opt.estim=list(Ngibbs=200,Nmh=600,thetaInit=c(1,1,11,0.1),r=c(0.3,0.3),
sig=diag(4),Nchains=1,burnIn=100)
###### Run the calibration
mdfit <- calibrate(md,pr,opt.estim)

mcmc <- chain(mdfit)
### Check coda object
is.mcmc(mcmc)
### get all the chain
mcmc <- chain(mdfit,coda=FALSE)
head(mcmc)

### Multi chains
opt.estim=list(Ngibbs=200,Nmh=600,thetaInit=c(1,1,11,0.1),r=c(0.3,0.3),
sig=diag(4),Nchains=2,burnIn=100)
###### Run the calibration
mdfit2 <- calibrate(md,pr,opt.estim)

mcmc <- chain(mdfit2)
is.mcmc.list(mcmc)
}
}
\seealso{
\code{\link{model}}, \code{\link{prior}}, \code{\link{calibrate}}, \code{\link{sequentialDesign}}
}
\author{
M. Carmassi
}
