% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom_search.R
\name{catr_atom_search_munic}
\alias{catr_atom_search_munic}
\title{ATOM INSPIRE: Search for municipality codes}
\usage{
catr_atom_search_munic(
  munic,
  to = NULL,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{munic}{Municipality to extract, It can be a part of a string or the
cadastral code.}

\item{to}{Optional parameter for defining the Territorial Office to which
\code{munic} belongs. This parameter is a helper for narrowing the search.}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching} section on \code{\link[=catr_set_cache_dir]{catr_set_cache_dir()}}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \CRANpkg{tibble}.
}
\description{
Search for a municipality (as a string, part of string or code) and get
the corresponding coding as per the Cadastre.
}
\examples{
\donttest{
catr_atom_search_munic("Mad")
}
}
\seealso{
Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()}

Other search: 
\code{\link{catr_get_code_from_coords}()},
\code{\link{catr_ovc_get_cod_munic}()},
\code{\link{catr_ovc_get_cod_provinces}()}

Other databases: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_srs_values}}
}
\concept{ATOM}
\concept{databases}
\concept{search}
