% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_semipmetric_erf.R
\name{estimate_semipmetric_erf}
\alias{estimate_semipmetric_erf}
\title{Estimate Semi-exposure-response Function (semi-ERF).}
\usage{
estimate_semipmetric_erf(formula, family, data, ci_appr)
}
\arguments{
\item{formula}{a vector of outcome variable in matched set.}

\item{family}{a description of the error distribution (see ?gam).}

\item{data}{dataset that formula is build upon.}

\item{ci_appr}{causal inference approach (matching or weighting).}
}
\value{
returns an object of class gam
}
\description{
Estimates the smoothed exposure-response function using a generalized
additive model with splines.
}
\details{
This approach uses Generalized Additive Model (gam) using mgcv package.
}
\examples{
m_d <- generate_syn_data(sample_size = 100)
pseudo_pop <- generate_pseudo_pop(m_d$Y,
                                  m_d$treat,
                                  m_d[c("cf1","cf2","cf3","cf4","cf5","cf6")],
                                  ci_appr = "matching",
                                  pred_model = "sl",
                                  sl_lib = c("m_xgboost"),
                                  params = list(xgb_nrounds=c(10,20,30),
                                   xgb_eta=c(0.1,0.2,0.3)),
                                  nthread = 1,
                                  covar_bl_method = "absolute",
                                  covar_bl_trs = 0.1,
                                  max_attempt = 1,
                                  matching_fun = "matching_l1",
                                  delta_n = 1,
                                  scale = 0.5)

outcome_m <- estimate_semipmetric_erf (formula = Y ~ w,
                                       family = gaussian,
                                       data = pseudo_pop$pseudo_pop,
                                       ci_appr = "matching")


}
