% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_params.r
\name{engineParams}
\alias{engineParams}
\title{Specify engine parameters for model execution}
\usage{
engineParams(
  model,
  sort = NULL,
  ODE = "MatrixExponent",
  rtolODE = 1e-06,
  atolODE = 1e-06,
  maxStepsODE = 50000,
  numIterations = 1000,
  method = NULL,
  stdErr = NULL,
  isCentralDiffStdErr = TRUE,
  stepSizeStdErr = NULL,
  numIntegratePtsAGQ = 1,
  numIterNonParametric = 0,
  allowSyntheticGradient = FALSE,
  numIterMAPNP = 0,
  numRepPCWRES = 0,
  stepSizeLinearize = 0.002,
  numDigitLaplacian = 7,
  numDigitBlup = 13,
  mapAssist = 0,
  iSample = 300,
  iAcceptRatio = 0.1,
  impDist = "Normal",
  tDOF = 4,
  numSampleSIR = 10,
  numBurnIn = 0,
  freezeOmega = FALSE,
  MCPEM = FALSE,
  runAllIterations = FALSE,
  scramble = "Owen",
  stepSizePartialDeriv = 1e-05,
  numTimeStepPartialDeriv = 20
)
}
\arguments{
\item{model}{Model object}

\item{sort}{Logical; Specifying whether or not to sort the input data by subject and time values.
\itemize{
\item If \code{model@hasResetInfo = TRUE}, then \code{sort} must be set to \code{FALSE} (default);
\item Otherwise, the default value for \code{sort} is \code{TRUE}.
}}

\item{ODE}{Character; Specifying the solver used to numerically solve
Ordinary Differential Equations (ODEs). Options are `"MatrixExponent"`,
`"Higham"`, `"DVERK"`, `"DOPRI5"`, `"AutoDetect"`, `"Stiff"`. See Details
section.}

\item{rtolODE}{Numeric; Specifying relative tolerance for the numerical ODE solver.}

\item{atolODE}{Numeric; Specifying absolute tolerance for the numerical ODE solver.}

\item{maxStepsODE}{Numeric; Specifying maximum number of allowable steps or function evaluations for the ODE solver.}

\item{numIterations}{Numeric; Specifying maximum number of iterations for estimation.}

\item{method}{Character; Specifying engine method for estimation. For population models,
options are \code{"QRPEM"}, \code{"IT2S-EM"}, \code{"FOCE-LB"}, \code{"FO"},
\code{"FOCE-ELS"}, \code{"Laplacian"}, \code{"Naive-Pooled"}.
While, for individual models, \code{"Naive-Pooled"} is the only option.\cr

Note: For population models, if \code{model} involves any discontinuous observed variable (e.g., count data) or BQL data,
the default method is \code{"Laplacian"}; otherwise, the default method is \code{"FOCE-ELS"}.}

\item{stdErr}{Character; Specifying method for standard error computations.  \cr
\itemize{
\item For individual models, options are \code{"Hessian"} (default) and \code{"None"};
\item For population models with \code{method = "QRPEM"}, options are \code{"Fisher-Score"} (default) and \code{"None"};
\item For population models with \code{method = "IT2s-EM"}, the only option is \code{"None"};
\item For population models with \code{method} set to either \code{"FOCE-LB"}, \code{"FO"},
\code{"FOCE-ELS"}, \code{"Laplacian"}, or \code{"Naive-Pooled"}, options are \code{"Sandwich"} (default),
\code{"Hessian"}, \code{"Fisher-Score"}, \code{"Auto-Detect"}, and \code{"None"}.
}
Here \code{"None"} means that standard error calculations are not performed.}

\item{isCentralDiffStdErr}{Logical; Default \code{TRUE} uses central difference for \code{stdErr} calculations.
Set to \code{FALSE} for forward difference method.}

\item{stepSizeStdErr}{Numeric; Specifying the step size used for \code{stdErr} calculations.
If not specified, 0.01 is used for population models and 0.001 for individual models.}

\item{numIntegratePtsAGQ}{Numeric; Specifying the number of integration points
for adaptive Gaussian quadrature (AGQ) algorithm. Only applicable to population models with
 \code{method} set to either \code{"FOCE-ELS"} or \code{"Laplacian"}.}

\item{numIterNonParametric}{Numeric;  Specifying the number of iterations to perform non-parametric estimation.
Only applicable to population models when \code{method} is not set to \code{Naive-Pooled}.}

\item{allowSyntheticGradient}{Logical, Set to \code{TRUE} to use synthetic gradient during the estimation process.
Only applicable to population models when \code{method} is not set to \code{Naive-Pooled}.}

\item{numIterMAPNP}{Numeric; Specifying the number of iterations
to perform Maximum A Posterior (MAP) initial Naive Pooling (NP) run before estimation.
Only applicable to population models when \code{method} is not set to \code{Naive-Pooled}.}

\item{numRepPCWRES}{Numeric; Specifying the number of replicates to generate the PCWRES
after the simple estimation. Only applicable to population models when \code{method} is not set to \code{Naive-Pooled}.}

\item{stepSizeLinearize}{Numeric; Specifying the step size used for numerical differentiation
when linearizing the model function during the estimation process.}

\item{numDigitLaplacian}{Numeric; Specifying the number of significant decimal digits for the Laplacian algorithm
to use to reach convergence. Only applicable to population models.}

\item{numDigitBlup}{Numeric; Specifying the number of significant decimal digits for the individual estimation
to use to reach convergence. Only applicable to population models.}

\item{mapAssist}{Numeric; Specifying the period used to perform MAP assistance (\code{mapAssist = 0} means that
MAP assistance is not performed). Only applicable to population models with \code{method = "QRPEM"}.}

\item{iSample}{Numeric; Specifying the number of samples. Only applicable to population models with \code{method = "QRPEM"}.}

\item{iAcceptRatio}{Numeric; Specifying the acceptance ratio. Only applicable to population models with \code{method = "QRPEM"}.}

\item{impDist}{Character; Specifying the distribution used for important sampling, and options are
\code{"Normal"} (default), \code{"DoubleExponential"}, \code{"Direct"}, \code{"T"}, \code{"Mixture-2"}, \code{Mixture-3}.
Only applicable to population models with \code{method = "QRPEM"}.}

\item{tDOF}{Numeric; Specifing the degree of freedom (allowed value is between 3 and 30) for T distribution.
Only applicable to population models with \code{method = "QRPEM"} and \code{impDist = "T"}.}

\item{numSampleSIR}{Numeric; Specifying the number of samples per subject used
in the Sampling Importance Re-Sampling (SIR) algorithm to determine the number of SIR samples
taken from the empirical discrete distribution that approximates the target conditional distribution.
Only applicable to population models with \code{method = "QRPEM"}.}

\item{numBurnIn}{Numeric; Specifying the number of burn-in iterations to perform at startup
to adjust certain internal parameters. Only applicable to population models with \code{method = "QRPEM"}.}

\item{freezeOmega}{Logical; Set to \code{TRUE} to freeze Omega but not Theta for the number of iterations
specified in the \code{numBurnIn}. Only applicable to population models with \code{method = "QRPEM"}.}

\item{MCPEM}{Logical; Set to \code{TRUE} to use Monte-Carlo sampling instead of Quasi-Random.
Only applicable to population models with \code{method = "QRPEM"}.}

\item{runAllIterations}{Logical; Set to \code{TRUE} to execute all requested iterations specified in \code{numIterations}.
Only applicable to population models with \code{method = "QRPEM"}.}

\item{scramble}{Character; Specifying the quasi-random scrambling method to use,
and options are \code{"Owen"}, \code{"Tezuka-Faur"}, or \code{"None"}.
Only applicable to population models with \code{method = "QRPEM"}.}

\item{stepSizePartialDeriv}{Numeric; Specifying the step size used to numerically calculate the partial derivatives
of observed variables with respect to parameters. Only applicable to individual models.}

\item{numTimeStepPartialDeriv}{Numeric; Specifying the number of time steps used to output the partial derivatives
of observed variables with respect to parameters. Only applicable to individual models.}
}
\value{
List of engine parameters to be used during fitting or simulation
}
\description{
Use to define extra engine parameters for model execution.
}
\details{
Both `"DVERK"` and `"DOPRI5"` are non-stiff solvers. `"Higham"` is a matrix
exponent based ODE solver which could be useful when overscaling issue should
be avoided, i.e. the ratio between observed values and doses is too high or
too low. `"AutoDetect"` represents LSODA solver implemenation, which solves
the initial value problem for stiff or nonstiff systems of first order
ordinary differential equations. `"Stiff"` is a LSODE (Livermore solver). It
is best suited for stiff problems.
}
