% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Database.R
\name{insertResultsToDatabase}
\alias{insertResultsToDatabase}
\title{Upload the results into a result database}
\usage{
insertResultsToDatabase(
  connectionDetails,
  schema,
  resultsFolder,
  tablePrefix = "",
  csvTablePrefix = "c_"
)
}
\arguments{
\item{connectionDetails}{The connection details to the result database}

\item{schema}{The schema for the result database}

\item{resultsFolder}{The folder containing the csv results}

\item{tablePrefix}{A prefix to append to the result tables for the characterization results}

\item{csvTablePrefix}{The prefix added to the csv results - default is 'c_'}
}
\value{
Returns the connection to the sqlite database
}
\description{
This function uploads results in csv format into a result database
}
\details{
Calls ResultModelManager uploadResults function to upload the csv files
}
\examples{

# generate results into resultsFolder
conDet <- exampleOmopConnectionDetails()

drSet <- createDechallengeRechallengeSettings(
  targetIds = c(1,2),
  outcomeIds = 3
)

cSet <- createCharacterizationSettings(
  dechallengeRechallengeSettings = drSet
)

runCharacterizationAnalyses(
  connectionDetails = conDet,
  targetDatabaseSchema = 'main',
  targetTable = 'cohort',
  outcomeDatabaseSchema = 'main',
  outcomeTable = 'cohort',
  cdmDatabaseSchema = 'main',
  characterizationSettings = cSet,
  outputDirectory = tempdir()
)

# create sqlite database
charResultDbCD <- createSqliteDatabase()

# create database results tables
createCharacterizationTables(
   connectionDetails = charResultDbCD,
   resultSchema = 'main'
 )

# insert results
insertResultsToDatabase(
 connectionDetails = charResultDbCD,
 schema = 'main',
 resultsFolder = tempdir()
)


}
\seealso{
Other Database: 
\code{\link{createCharacterizationTables}()},
\code{\link{createSqliteDatabase}()}
}
\concept{Database}
