% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reviewAllSpectra.R
\name{reviewAllSpectra}
\alias{reviewAllSpectra}
\title{Review All the Spectra in a Spectra Object}
\usage{
reviewAllSpectra(spectra, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[=GraphicsOptions]{GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Utility to review all spectra in a \code{Spectra} object.  Output depends upon the graphics
output choice.
\describe{
\item{base:}{Plots each spectrum one at a time, and waits for a return in the console before
plotting the next spectrum.  Use \code{ESC} to get out of the loop.}
\item{ggplot2:}{All the spectra are plotted in a single column.}
}
}
\examples{
# Because there are 16 spectra in this data set, you probably want to
# expand the height of the graphics device to see the spectra clearly.
# This example assumes the graphics output is set to ggplot2 or plotly (see ?GraphicsOptions).
# If you do options(ChemoSpecGraphics == "plotly") you'll get the results
# in a web page, which is particularly convenient.
library("ggplot2")
data(metMUD1)
p <- reviewAllSpectra(metMUD1)
p


}
\seealso{
See \code{\link{GraphicsOptions}}
for more information about the graphics options. Additional documentation at
\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
