% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclust3dSpectra.R
\name{mclust3dSpectra}
\alias{mclust3dSpectra}
\title{mclust Analysis of a Spectra Object in 3D}
\usage{
mclust3dSpectra(
  spectra,
  pca,
  pcs = 1:3,
  ellipse = TRUE,
  rob = FALSE,
  cl = 0.95,
  frac.pts.used = 0.8,
  truth = NULL,
  ...
)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{pca}{An object of class \code{\link{prcomp}}.}

\item{pcs}{An integer vector describing which PCs to use.}

\item{ellipse}{Logical indicating if confidence ellipses should be drawn.}

\item{rob}{Logical; if \code{ellipse = TRUE}, indicates that robust
confidence ellipses should be drawn.  If \code{FALSE}, classical confidence
ellipses are drawn.}

\item{cl}{A number indicating the confidence interval for the ellipse.}

\item{frac.pts.used}{If \code{ellipse = TRUE} and \code{rob = TRUE}, a
number indicating the fraction of the data points to be considered "good"
and thus used to compute the robust confidence ellipse.}

\item{truth}{A character vector indicating the known group membership for
reach row of the PC scores.  Generally this would be \code{spectra$groups}.}

\item{...}{Arguments to be passed to \code{mclust}.}
}
\value{
The mclust model is returned invisibly, and a plot is produced.
}
\description{
This function conducts an mclust analysis of the PCA results of a
\code{\link{Spectra}} object and displays the results in 3D.  Classical or
robust confidence ellipses can be added if desired. Improperly classified
data points can be marked.  The interactive plot is made via \code{plotly}
and appears in a browser window. Note that the confidence ellipses computed
here are generated independently of the \code{Mclust} results - they do not
correspond to the ellipses seen in 2D plots from \code{Mclust}.
}
\examples{
\dontrun{
require(mclust)
data(metMUD1)
pca <- c_pcaSpectra(metMUD1)
mclust3dSpectra(metMUD1, pca)

# show mis-classified points
mclust3dSpectra(metMUD1, pca, truth = metMUD1$groups)
}

}
\seealso{
\code{\link[mclust]{Mclust}} for background on the method.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{cluster}
\keyword{multivariate}
