% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rInvWishart}
\alias{rInvWishart}
\title{Random Inverse Wishart Distributed Matrices}
\usage{
rInvWishart(n, df, Sigma)
}
\arguments{
\item{n}{integer sample size.}

\item{df}{numeric parameter, "degrees of freedom".}

\item{Sigma}{positive definite \eqn{p \times p}{(p * p)} "scale" matrix, the matrix parameter of the
distribution.}
}
\value{
a numeric array, say \code{R}, of dimension \eqn{p \times p \times n}{p * p * n},
where each \code{R[,,i]} is a realization of the inverse Wishart distribution \eqn{IW_p(Sigma, df)}.
Based on a modification of the existing code for the \code{rWishart} function.
}
\description{
Generate n random matrices, distributed according
    to the inverse Wishart distribution with parameters \code{Sigma} and
    \code{df}, \eqn{W_p(Sigma, df)}.

   Note there are different ways of parameterizing the Inverse
   Wishart distribution, so check which one you need.
    Here,  If \eqn{X \sim IW_p(\Sigma, \nu)}{X ~ IW_p(Sigma, df)} then
    \eqn{X^{-1} \sim W_p(\Sigma^{-1}, \nu)}{X^{-1} ~ W_p(Sigma^{-1}, df)}.
    Dawid (1981) has a different definition: if
    \eqn{X \sim W_p(\Sigma^{-1}, \nu)}{X ~ W_p(Sigma^{-1}, df)} and
    \eqn{\nu > p - 1}{df > p - 1}, then
    \eqn{X^{-1} = Y \sim IW(\Sigma, \delta)}{X^{-1} = Y ~ IW(Sigma, delta)}, where
    \eqn{\delta = \nu - p + 1}{delta = df - p + 1}.
}
\examples{
set.seed(20180221)
A<-rInvWishart(1,10,5*diag(5))[,,1]
set.seed(20180221)
B<-rWishart(1,10,.2*diag(5))[,,1]

A \%*\% B
}
\references{
Dawid, A. (1981). Some Matrix-Variate Distribution Theory: Notational Considerations and a
Bayesian Application. \emph{Biometrika}, 68(1), 265-274. \doi{10.2307/2335827}

Gupta, A. K.  and D. K. Nagar (1999). \emph{Matrix variate distributions}. Chapman and Hall.

Mardia, K. V., J. T. Kent, and J. M. Bibby (1979) \emph{Multivariate Analysis},
London: Academic Press.
}
\seealso{
\code{\link{rWishart}}, \code{\link{rCholWishart}}, and \code{\link{rInvCholWishart}}
}
