% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEvapotranspiration.R
\name{getEvapotranspiration}
\alias{getEvapotranspiration}
\title{Assemble an evapotranspiration times series}
\usage{
getEvapotranspiration(start, end, geometry, att, val = NA)
}
\arguments{
\item{start}{start date in format 'YYYY-MM-DD'}

\item{end}{end date in format 'YYYY-MM-DD'}

\item{geometry}{name of geometry as displayed in GDP}

\item{att}{attribute of geometry as displayed in GDP}

\item{val}{values of attribute as displayed in GDP}
}
\value{
monthly evapotranspiration, averaged spatially over geometry
}
\description{
This function retrieves monthly actual evapotranspiration for a given area
from SSEBop model output hosted by the USGS Geo Data Portal (GDP)
}
\examples{
\dontrun{
et = getEvapotranspiration('2010-01-01', '2010-12-31', 'sample:Counties',
'STATE', 'RI') 
}
}
