% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_changes_on_tree.R
\name{plot_changes_on_tree}
\alias{plot_changes_on_tree}
\title{Plots character changes on branches}
\usage{
plot_changes_on_tree(character_changes, time_tree, label_size = 0.5)
}
\arguments{
\item{character_changes}{A matrix of character changes.}

\item{time_tree}{Tree on which character changes occur.}

\item{label_size}{The size of the text for the barnch labels. Default is 0.5.}
}
\value{
A plot of character changes on a tree.
}
\description{
Plots character changes in boxes on branches.
}
\details{
Takes the \code{character_changes} output from \link{test_rates} and plots it on the tree used to generate it.
}
\examples{

# Set random seed:
set.seed(17)

# Get first MPT for the Michaux data set:
time_tree <- ape::read.tree(text = paste0("(Ancilla:31.6,(Turrancilla:102.7,",
  "(Ancillista:1,Amalda:63.5):1):1);"))

# Set root time for tree:
time_tree$root.time <- 103.7

# Get discrete character rates (includes changes):
out <- test_rates(time_tree, michaux_1989,
  seq(time_tree$root.time, 0, length.out = 3),
  branch_partitions = list(list(1)), alpha = 0.01
)

# Plot character changes on the tree:
plot_changes_on_tree(
  out$inferred_character_changes,
  time_tree
)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
