% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_time_bins.R
\name{partition_time_bins}
\alias{partition_time_bins}
\title{Time bin partitioner}
\usage{
partition_time_bins(n_time_bins, partition_sizes_to_include = "all")
}
\arguments{
\item{n_time_bins}{The number of time bins.}

\item{partition_sizes_to_include}{Either "all" (the default) or a vector of requested partition sizes.}
}
\value{
Returns a list of lists of vectors ready for use in \link{test_rates}.
}
\description{
Generates all possible contiguous partitions of N time bins.
}
\details{
This function is designed for use with the \link{test_rates} function and generates all possible contiguous partitions of N time bins. This allows use of an information criterion like AIC to pick a "best" partition, weighing fit and partition number simultaneously.

You can also ask for only partitions of a specific number using the \code{partition_sizes_to_include} option. For example, \code{partition_sizes_to_include = c(1, 2, 3)} will only return partitions of 1, 2, or 3 sets of elements.
}
\examples{

# Get all partitions for four time bins:
partition_time_bins(n_time_bins = 4)

# Get all partitions for five time bins of size 2:
partition_time_bins(n_time_bins = 5, partition_sizes_to_include = 2)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
