% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimaRep-package.R
\docType{package}
\name{ClimaRep-package}
\alias{ClimaRep-package}
\alias{ClimaRep}
\title{ClimaRep: Estimating Climate Representativeness}
\description{
Offers tools to estimate the climate representativeness of defined areas and quantifies and analyzes its transformation under future climate change scenarios. Approaches described in Mingarro and Lobo (2018) \doi{10.32800/abc.2018.41.0333} and Mingarro and Lobo (2022) \doi{10.1017/S037689292100014X}.

\subsection{Overview}{

The primary goal of \code{ClimaRep} is to quantify how well the climate within specific polygons (\code{sf}) represents the broader climate space defined by climate variables (\code{SpatRaster}) within a study area (\code{sf}).
It also provides functions to evaluate how this representativeness changes under projected future climate conditions.
}

\subsection{Key Features}{

The package includes functions for:
\itemize{
\item Filtering raster climate variables to reduce multicollinearity (\code{vif_filter}).
\item Estimating current climate representativeness (\code{mh_rep}).
\item Estimating changes in climate representativeness under future climate projections (\code{mh_rep_ch}).
\item Estimating climate representativeness overlay (\code{mh_overlay}).
}
}

\subsection{More Details}{

https://github.com/MarioMingarro/ClimaRep
}
}
\author{
\strong{Maintainer}: Mario Mingarro Lopez \email{mario_mingarro@mncn.csic.es} (\href{https://orcid.org/0000-0003-3977-7944}{ORCID})

}
\keyword{internal}
