% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icp.torus.R
\name{icp.torus.score}
\alias{icp.torus.score}
\title{Conformity score for inductive prediction sets}
\usage{
icp.torus.score(
  data,
  split.id = NULL,
  method = c("all", "kde", "mixture", "kmeans"),
  mixturefitmethod = c("circular", "axis-aligned", "general", "Bayesian"),
  kmeansfitmethod = c("homogeneous-circular", "heterogeneous-circular", "ellipsoids",
    "general"),
  init = c("kmeans", "hierarchical"),
  additional.condition = TRUE,
  param = list(J = 4, concentration = 25),
  kmax = 500,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = TRUE
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}}

\item{split.id}{a n-dimensinal vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{method}{a string one of "all", "kde", "mixture", and "kmeans"
which determines the model for clustering. Default is "all". Moreover, if
the dimension of data space is larger than 2, then automatically
"kmeans".}

\item{mixturefitmethod}{a string one of "circular", "axis-aligned", "general",
and "Bayesian" which determines the fitting mixture method.("Bayesian" is not yet
supported) Default is "axis-aligned".}

\item{kmeansfitmethod}{character which must be "homogeneous-circular",
"heterogeneous-circular", or "general".
 If "homogeneous-circular", the radii of k-spheres are identical.
 If "heterogeneous-cricular", the radii of k-spheres may be different.
 If "ellipsoids", cluster with k-ellipsoids without optimized parameters.
 If, "general", clustering with k-ellipses. The parameters to construct
 the ellipses are optimized with generalized Lloyd algorithm, which is
 modified for toroidal space. To see the detail, see the references.}

\item{init}{determine the initial parameter of "kmeans" method,
for option "general". Must be "kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic kmeans
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method.
Default is "kmeans".}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{param}{the number of components (in \code{list} form) for mixture
fitting and the concentration parameter.}

\item{kmax}{the maximal number of kappa. If estimated kappa is
larger than \code{kmax}, then put kappa as \code{kmax}.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will be reported.}
}
\value{
returns an \code{icp.torus} object, containing all values
  to compute the conformity score.
}
\description{
\code{icp.torus.score} prepares all values
  for computing the conformity score for specified methods.
}
\examples{
\donttest{
data <- toydata1[, 1:2]

icp.torus <- icp.torus.score(data, method = "all",
                             mixturefitmethod = "general",
                             kmeansfitmethod = "general",
                             param = list(J = 4, concentration = 25))
}
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
