% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-utils.R
\name{calculate_markers}
\alias{calculate_markers}
\title{Calculate markers}
\usage{
calculate_markers(
  expression_matrix,
  cells1,
  cells2,
  logfc_threshold = 0,
  min_pct_threshold = 0.1,
  avg_expr_threshold_group1 = 0,
  min_diff_pct_threshold = -Inf,
  rank_matrix = NULL,
  feature_names = NULL,
  used_slot = "data",
  norm_method = "SCT",
  pseudocount_use = 1,
  base = 2,
  adjust_pvals = TRUE,
  check_cells_set_diff = TRUE
)
}
\arguments{
\item{expression_matrix}{A matrix of gene expression values having genes
in rows and cells in columns.}

\item{cells1}{A vector of cell indices for the first group of cells.}

\item{cells2}{A vector of cell indices for the second group of cells.}

\item{logfc_threshold}{The minimum absolute log fold change to consider a
gene as differentially expressed. Defaults to \code{0}, meaning all genes are
taken into considereation.}

\item{min_pct_threshold}{The minimum fraction of cells expressing a gene
form each cell population to consider the gene as differentially expressed.
Increasing the value will speed up the function. Defaults to \code{0.1}.}

\item{avg_expr_threshold_group1}{The minimum average expression that a gene
should have in the first group of cells to be considered as differentially
expressed. Defaults to \code{0}.}

\item{min_diff_pct_threshold}{The minimum difference in the fraction of cells
expressing a gene between the two cell populations to consider the gene as
differentially expressed. Defaults to \code{-Inf}.}

\item{rank_matrix}{A matrix where the cells are ranked based on their
expression levels with respect to each gene. Defaults to \code{NULL}, in which
case the function will calculate the rank matrix. We recommend calculating
the rank matrix beforehand and passing it to the function to speed up the
computation.}

\item{feature_names}{A vector of gene names. Defaults to \code{NULL}, in which
case the function will use the row names of the expression matrix as gene
names.}

\item{used_slot}{Parameter that provides additional information about the
expression matrix, whether it was scaled or not. The value of this parameter
impacts the calculation of the fold change. If \code{data}, the function will
calculates the fold change as the fraction between the log value of the
average of the expression raised to exponential for the two cell groups. If
\code{scale.data}, the function will calculate the fold change as the fraction
between the average of the expression values for the two cell groups.
Other options will default to calculating the fold change as the fraction
between the log value of the average of the expression values for the two
cell groups. Defaults to \code{data}.}

\item{norm_method}{The normalization method used to normalize the expression
matrix. The value of this parameter impacts the calculation of the average
expression of the genes when \code{used_slot = "data"}. If \code{LogNormalize}, the
log fold change will be calculated as described for the \code{used_slot}
parameter. Otherwise, the log fold change will be calculated as the fraction
between the log value of the average of the expression values for the two
cell groups. Defaults to \code{SCT}.}

\item{pseudocount_use}{The pseudocount to add to the expression values when
calculating the average expression of the genes, to avoid the 0 value for
the denominator. Defaults to \code{1}.}

\item{base}{The base of the logharithm. Defaults to \code{2}.}

\item{adjust_pvals}{A logical value indicating whether to adjust the p-values
for multiple testing using the Bonferonni method. Defaults to \code{TRUE}.}

\item{check_cells_set_diff}{A logical value indicating whether to check if
thw two cell groups are disjoint or not. Defaults to \code{TRUE}.}
}
\value{
A data frame containing the following columns:
\itemize{
\item \code{gene}: The gene name.
\item \code{avg_log2FC}: The average log fold change between the two cell groups.
\item \code{p_val}: The p-value of the Wilcoxon rank sum test.
\item \code{p_val_adj}: The adjusted p-value of the Wilcoxon rank sum test.
\item \code{pct.1}: The fraction of cells expressing the gene in the first cell group.
\item \code{pct.2}: The fraction of cells expressing the gene in the second cell group.
\item \code{avg_expr_group1}: The average expression of the gene in the first cell group.
}
}
\description{
Performs the Wilcoxon rank sum test to identify differentially
expressed genes between two groups of cells.
}
\examples{
set.seed(2024)
# create an artificial expression matrix
expr_matrix <- matrix(
    c(runif(100 * 50), runif(100 * 50, min = 3, max = 4)),
    ncol = 200, byrow = FALSE
)
colnames(expr_matrix) <- as.character(1:200)
rownames(expr_matrix) <- paste("feature", 1:50)

calculate_markers(
    expression_matrix = expr_matrix,
    cells1 = 101:200,
    cells2 = 1:100
)
# TODO should be rewritten such that you don't create new matrix objects inside
# just
}
