% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{create_monocle_from_clustassess_app}
\alias{create_monocle_from_clustassess_app}
\title{Create monocle object from a ClustAssess shiny app}
\usage{
create_monocle_from_clustassess_app(
  app_folder,
  stable_feature_type,
  stable_feature_set_size,
  stable_clustering_method,
  stable_n_clusters = NULL,
  use_all_genes = FALSE
)
}
\arguments{
\item{app_folder}{Path pointing to the folder containing a ClustAssess app.}

\item{stable_feature_type}{The feature type which leads to stable clusters.}

\item{stable_feature_set_size}{The feature size which leads to stable
clusters.}

\item{stable_clustering_method}{The clustering method which leads to stable
clusters.}

\item{stable_n_clusters}{The number of clusters that are stable. If NULL,
all the clusters will be provided. Defaults to \code{NULL}.}

\item{use_all_genes}{A boolean value indicating if the expression matrix
should be truncated to the genes used in the stability assessment. Defaults
to \code{FALSE}.}
}
\value{
A Monocle object of the expression matrix, having the stable number
of clusters identified by ClustAssess.
}
\description{
Use the files generated in the ClustAssess app to create a
Monocle object which has the stable number of clusters.
}
