% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-2-graph-construction.R
\name{plot_n_neigh_ecs}
\alias{plot_n_neigh_ecs}
\title{Graph construction parameters - ECC facet}
\usage{
plot_n_neigh_ecs(nn_ecs_object, boxplot_width = 0.5)
}
\arguments{
\item{nn_ecs_object}{An object or a concatenation of objects returned by the
\code{get_nn_importance} method.}

\item{boxplot_width}{Used for adjusting the width of the boxplots; the value will
be passed to the \code{width} argument of the \code{ggplot2::geom_boxplot} method.}
}
\value{
A ggplot2 object.
}
\description{
Display, for all configurations consisting in different number
of neighbours, graph types and base embeddings, the EC Consistency of the partitions
obtained over multiple runs on an UMAP embedding.
}
\examples{
set.seed(2024)
# create an artificial PCA embedding
pca_emb <- matrix(runif(100 * 30), nrow = 100, byrow = TRUE)
rownames(pca_emb) <- as.character(1:100)
colnames(pca_emb) <- paste0("PC_", 1:30)

nn_stability_obj <- assess_nn_stability(
    embedding = pca_emb,
    n_neigh_sequence = c(10, 15, 20),
    n_repetitions = 10,
    graph_reduction_type = "PCA",
    clustering_algorithm = 1
)
plot_n_neigh_ecs(nn_stability_obj)
}
