% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{dimJump.R}
\alias{dimJump.R}

\title{Data driven calibration of the penalty function}

\usage{
  dimJump.R(fileOrData, h = integer(), N = integer(), header = logical())
}

\arguments{
\item{fileOrData}{A character string or a data frame (see details). If a data frame, it must contain columns named \code{logLik} and \code{dim}.
If a file, it must be as the one produced by \code{\link{backward.explorer}}.}

\item{h}{An integer defining the size of the sliding window used to find the biggest jump.}

\item{N}{The size of the sample data (number of rows).}

\item{header}{The indication of whether the file contains header or not.}
}

\description{
  Data driven calibration of the penalty function using the dimension jump version of the "slope heuristics".
}

\value{
  Assume that the penalty function is in the form \deqn{pen\left(K,S\right) = \alpha*\lambda*dim\left(K,S\right)}, where 
  \itemize{
  \item \eqn{\lambda} is the penalty parameter to be calibrated,
  \item and \eqn{\alpha} a coeffcient belonging to \eqn{[1.5,2]}, to be given by the user in  \code{\link{model.selection.R}} for the final selection.
  }
  
  It returns a list containing two candidate values of \eqn{\lambda} and their bounds. It also produces a graphic that illustrates the "slope heuristics".
}

\details{
This function is a dimension jump version of the so called \emph{slope heuristics} for the calibration of penalty function using the data.
}
\examples{
# genotype2_ExploredModels was obtained via backward.explorer.
data(genotype2_ExploredModels)
outDimJump = dimJump.R(genotype2_ExploredModels, N = 1000, h = 5, header = TRUE)
outDimJump[[1]]
}

\author{
Wilson Toussile
}

\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and 
		variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 
		selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{backward.explorer}} for exploration of competing models space, \code{\link{model.selection.R}} for final selection.
}
\keyword{Classification}
\keyword{Cluster}
\keyword{Slope-heuristics}
\keyword{Model selection}
\keyword{Penalized maximum log-likelihood}


