(defpackage "SHARED-LIBRARY" (:use "XLISP") (:nicknames "SHLIB"))
(in-package "SHARED-LIBRARY")

(defun lisp-to-arg (x)
  (let* ((seq (if (sequencep x) x (list x)))
         (type (if (every #'integerp seq) '(vector c-long) '(vector c-double)))
         (val (coerce seq type)))
    (if (eq val x) (copy-seq val) val)))
(defun arg-to-lisp (x) (coerce x 'list))
(defun old-call-cfun (name lib &rest args)
  (let* ((fun-addr (shlib-symaddr lib name))
         (argvecs (mapcar #'lisp-to-arg args))
         (arg-addrs (mapcar #'array-data-address argvecs)))
    (apply #'call-by-address fun-addr arg-addrs)
    (mapcar #'arg-to-lisp argvecs)))
