% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZeroData.R
\name{ZeroData}
\alias{ZeroData}
\title{Zero replacement}
\usage{
ZeroData(DaTa, method = "multKM", seed = NULL)
}
\arguments{
\item{DaTa}{data.frame. The first column contains the time point information (natural numbers 1,2,3...). The rest of the columns contain the relative abundance of each bacteria at the different time points. The values of each column must sum 1.}

\item{method}{Character.
\itemize{
  \item If \code{method="multKM"} - The replacement is carried out with the "multiplicative Kaplan-Meier smoothing spline replacement" (Palarea-Albaladejo and Martín-Fernandez, 2015). Default method. The zeros must be written with a 0.
  \item If \code{method="multRepl"} -  The replacement is carried out with the "multiplicative simple replacement" (Palarea-Albaladejo and Martín-Fernandez, 2015).  The zeros must be written with a 0.
  \item If \code{method="nozeros"} - The bacteria that contains zeros are removed. One column is added to the dataset called "Other".
}}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.}
}
\value{
The dataset without zeros.
}
\description{
In this function the zeros are removed or replaced using functions of "zCompositions" package that can be used with longitudinal data (because they do not use the information of other rows to make the replacement).
}
\examples{

set.seed(2)
dat=gtools::rdirichlet(6,c(1,2,3,1,2,3))
dat2=dat
dat2[2,1]=0
dat2[2,2]=dat[2,1]+dat[2,2]
dat2[4,3]=0
dat2[4,4]=dat[4,3]+dat[4,4]

X <- cbind( c(1:6) ,dat2)

Final=ZeroData(X,"multKM",1)
Final2=ZeroData(X,"multRepl",1)

}
\references{
Palarea-Albaladejo J. and Martín-Fernandez JA. zCompositions – R package for multivariate imputation of left-censored data under a compositional approach. Chemometrics and Intelligent Laboratory Systems 2015; 143: 85-96.
}
