% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortOverlap.R
\name{tableCohortOverlap}
\alias{tableCohortOverlap}
\title{Format a summariseOverlapCohort result into a visual table.}
\usage{
tableCohortOverlap(
  result,
  uniqueCombinations = TRUE,
  type = "gt",
  header = c("variable_name"),
  groupColumn = c("cdm_name"),
  hide = c("variable_level")
)
}
\arguments{
\item{result}{A summariseOverlapCohort result.}

\item{uniqueCombinations}{Whether to display unique combinations
reference - comparator.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{tidyColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{tidyColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{tidyColumns(result)}.}
}
\value{
A formatted table of the summariseOverlapCohort result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- mockCohortCharacteristics()
overlap <- summariseCohortOverlap(cdm$cohort2)
tableCohortOverlap(overlap)
mockDisconnect(cdm = cdm)
}

}
