% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyCohorts.R
\name{stratifyCohorts}
\alias{stratifyCohorts}
\title{Crate a new cohort table with the specified stratifications.}
\usage{
stratifyCohorts(
  cohort,
  strata,
  cohortId = NULL,
  removeStrata = TRUE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{strata}{A strata list that point to columns in cohort table.}

\item{cohortId}{IDs of the cohorts to include. If NULL all cohorts will be
considered. Cohorts not included will be removed from the cohort set.}

\item{removeStrata}{Whether to remove strata columns from final cohort table.}

\item{name}{Name of the new cohort.}
}
\value{
Cohort table stratified.
}
\description{
Crate a new cohort table with the specified stratifications.
}
\examples{
\donttest{
library(CohortConstructor)
library(PatientProfiles)

cdm <- mockCohortConstructor()

cdm$my_cohort <- cdm$cohort1 |>
  addAge(ageGroup = list("child" = c(0, 17), "adult" = c(18, Inf))) |>
  addSex() |>
  stratifyCohorts(
    strata = list("sex", c("sex", "age_group")), name = "my_cohort"
  )

cdm$my_cohort

settings(cdm$my_cohort)

attrition(cdm$my_cohort)
}
}
