% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDemographics.R
\name{requireFutureObservation}
\alias{requireFutureObservation}
\title{Restrict cohort on future observation}
\usage{
requireFutureObservation(
  cohort,
  minFutureObservation,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{minFutureObservation}{A minimum number of future observation days in
the database.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in cohort that contains the date to compute the
demographics characteristics on which to restrict on.}

\item{name}{Name of the new cohort with the future observation restriction.}
}
\value{
The cohort table with only records for individuals satisfying the
future observation requirement
}
\description{
\code{requireFutureObservation()} filters cohort records, keeping only records
where individuals satisfy the specified future observation criteria.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  requireFutureObservation(indexDate = "cohort_start_date",
                           minFutureObservation = 30)
}
}
