% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyCohorts.R
\name{copyCohorts}
\alias{copyCohorts}
\title{Copy a cohort table}
\usage{
copyCohorts(cohort, name, n = 1, cohortId = NULL, .softValidation = TRUE)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{n}{Number of times to duplicate the selected cohorts.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A new cohort table containing cohorts from the original cohort table.
}
\description{
\code{copyCohorts()} copies an existing cohort table to a new location.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort3 <- copyCohorts(cdm$cohort1, n = 2, cohortId = 1, name = "cohort3")
}
}
