% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTypes.R
\name{GetCensWeight}
\alias{GetCensWeight}
\title{Calculates and returns data for time by hazard and survival to estimate censoring rate
\code{GetCensWeight} uses user provided data, time/event columns, vectors specifying the model, and options generate an estimate of the censoring rate, plots, and returns the data}
\usage{
GetCensWeight(
  df,
  time1,
  time2,
  event0,
  names,
  Term_n,
  tform,
  keep_constant,
  a_n,
  modelform,
  fir,
  control,
  plot_options,
  model_control = list(),
  Strat_Col = "e"
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{Term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters}

\item{modelform}{string specifying the model type}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{control}{list of parameters controlling the convergence}

\item{plot_options}{list of parameters controlling the plot options}

\item{model_control}{controls which alternative model options are used}

\item{Strat_Col}{column to stratify by if needed}
}
\value{
saves the plots in the current directory and returns a data.table of time and corresponding hazard, cumulative hazard, and survival
}
\description{
Calculates and returns data for time by hazard and survival to estimate censoring rate
\code{GetCensWeight} uses user provided data, time/event columns, vectors specifying the model, and options generate an estimate of the censoring rate, plots, and returns the data
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette

df <- data.table("UserID"=c(112, 114, 213, 214, 115, 116, 117),
           "Starting_Age"=c(18,  20,  18,  19,  21,  20,  18),
             "Ending_Age"=c(30,  45,  57,  47,  36,  60,  55),
          "Cancer_Status"=c(0,   0,   1,   0,   1,   0,   0),
                      "a"=c(0,   1,   1,   0,   1,   0,   1),
                      "b"=c(1,   1.1, 2.1, 2,   0.1, 1,   0.2),
                      "c"=c(10,  11,  10,  11,  12,  9,   11),
                      "d"=c(0,   0,   0,   1,   1,   1,   1))
# For the interval case
time1 <- "Starting_Age"
time2 <- "Ending_Age"
event <- "Cancer_Status"
names <- c('a','b','c','d')
Term_n <- c(0,1,1,2)
tform <- c("loglin","lin","lin","plin")
modelform <- "M"
fir <- 0
a_n <- c(0.1, 0.1, 0.1, 0.1)

keep_constant <- c(0,0,0,0)
der_iden <- 0
df$censor <- (df$Cancer_Status==0)
event <- "censor"
control <- list("Ncores"=2,'lr' = 0.75,'maxiter' = 20,'halfmax' = 5,
   'epsilon' = 1e-6,'dbeta_max' = 0.5,'deriv_epsilon' = 1e-6,
   'abs_max'=1.0,'change_all'=TRUE,'dose_abs_max'=100.0,'verbose'=FALSE,
   'ties'='breslow','double_step'=1)
plot_options <- list("name"=paste(tempfile(),"run_06",sep=""),"verbose"=FALSE,
                     "studyID"="studyID","age_unit"="years")
dft <- GetCensWeight(df, time1, time2, event, names, Term_n, tform,
                     keep_constant, a_n, modelform, fir, control, plot_options)
t_ref <- dft$t
surv_ref <- dft$surv
t_c <- df$t1
cens_weight <- approx(t_ref, surv_ref, t_c,rule=2)$y

}
