# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Utility function to define risk groups
#'
#' \code{Make_Groups} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
NULL

#' Utility function to define risk groups with competing risks
#'
#' \code{Make_Groups_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds rows with event = 2 past the event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
NULL

#' Utility function to define risk groups with Strata
#'
#' \code{Make_Groups_Strata} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
NULL

#' Utility function to define risk groups with Strata and competing risks
#'
#' \code{Make_Groups_Strata_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
NULL

#' Utility function to define matched risk groups
#'
#' \code{Make_Match} Called to update lists of risk groups, assumes the data is matched into one group and df_m only contains the event indicator
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time, and the various recursive matrices initialized
#' @noRd
#'
NULL

#' Utility function to define matched risk groups by strata
#'
#' \code{Make_Match_Strata} Called to update lists of risk groups, assumes the data is matched into strata and df_m only contains the strata value and then the event indicator
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time, and the various recursive matrices initialized
#' @noRd
#'
NULL

#' Utility function to define matched risk groups by time
#'
#' \code{Make_Match_Time} Called to update lists of risk groups, assumes the data is matched into groups by time at risk and df_m contains the interval times, and then event indicator
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time, and the various recursive matrices initialized
#' @noRd
#'
NULL

#' Utility function to define matched risk groups by time and strata
#'
#' \code{Make_Match_Time_Strata} Called to update lists of risk groups, assumes the data is matched into groups by time at risk as well as strata and df_m contains the interval times, the strata value, and then event indicator
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time, and the various recursive matrices initialized
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_PO} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation. but not derivatives
#'
#' \code{Calculate_Sides_Single} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata
#'
#' \code{Calculate_Sides_Strata} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with Strata and competing risks
#'
#' \code{Calculate_Sides_Strata_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives
#'
#' \code{Calc_LogLik} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives with outcome probability
#'
#' \code{Calc_LogLik} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives, basic model
#'
#' \code{Calc_LogLik_Basic} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives with linear ERR simplification
#'
#' \code{Calc_LogLik_Linear_ERR} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata and Linear ERR simplification
#'
#' \code{Calc_LogLik_Strata_Linear_ERR} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata
#'
#' \code{Calc_LogLik_Strata} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate Cox Log-Likelihood and derivatives with Strata, basic model
#'
#' \code{Calc_LogLik_Strata_BASIC} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time, basic model
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate poisson log-likelihood and derivatives
#'
#' \code{Poisson_LogLik} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to perform null model equivalent of Calculate_Sides
#'
#' \code{Calculate_Null_Sides} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to perform null model equivalent of Calculate_Sides with strata
#'
#' \code{Calculate_Null_Sides_Strata} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik_Strata} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Fills out recursive vectors for matched case-control logistic regression
#'
#' \code{Calculate_Recursive} Called to update the recursive vectors, uses model_bool list to select which vectors to update.
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Fills out recursive vectors for matched case-control logistic regression
#'
#' \code{Calc_Recur_LogLik} Called to update the recursive vectors, uses model_bool list to select which vectors to update.
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate Logistic Log-Likelihood and derivatives
#'
#' \code{Calc_LogLik_Logist} Called to update log-likelihoods, Uses probability matrices Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' checks if the model is viable
#'
#' \code{Check_Risk} Calculates risks and checks for negative values
#'
#' @inheritParams CPP_template
#'
#' @return True for viable point, False for negative error
#' @noRd
#'
NULL

#' Primary Cox PH regression with multiple starting points and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary poisson regression with multiple starting points and optional combinations of stratification and no derivative calculation.
#'
#' \code{LogLik_Pois_Omnibus} Performs the calls to calculation functions, Structures the poisson regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Matched Case-Control starting point
#'
#' \code{LogLik_CaseCon_Omnibus} Primary Matched Case-Control starting point
#'
#' @inheritParams CPP_template
#'
#' @return only if it works
#' @noRd
#'
NULL

#' Primary logistic regression with multiple starting points and optional combinations of stratification and no derivative calculation.
#'
#' \code{LogLik_Logist_Omnibus} Performs the calls to calculation functions, Structures the logistic regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Primary Cox PH regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Multidose_Omnibus_Serial} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, standard error, and convergence for each realization
#' @noRd
#'
NULL

#' Primary Cox PH regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Multidose_Omnibus_Integrated} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: standard cox outputs for the integrated solution
#' @noRd
#'
NULL

#' Primary Poisson regression with multiple distributed dose columns and optional combinations of stratification.
#'
#' \code{LogLik_Pois_Multidose_Omnibus_Serial} Performs the calls to calculation functions, Structures the Poisson regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, standard error, and convergence for each realization
#' @noRd
#'
NULL

#' Primary Poisson regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Pois_PH_Multidose_Omnibus_Integrated} Performs the calls to calculation functions, Structures the Poisson regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: standard cox outputs for the integrated solution
#' @noRd
#'
NULL

#' Utility function to refresh risk and subterm matrices for Cox Omnibus function
#'
#' \code{Cox_Refresh_R_TERM} Called to update matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place
#' @noRd
#'
NULL

#' Utility function to refresh side matrices for Cox Omnibus
#'
#' \code{Cox_Refresh_R_SIDES} Called to fresh repeated sum calculation matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to perform calculation of terms and risks for Cox Omnibus
#'
#' \code{Cox_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to perform calculation of Repeated Calculations and Log-Likelihood for Cox Omnibus
#'
#' \code{Cox_Side_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to print likelihood and derivatives
#'
#' \code{Print_LL} Called to print likelihood and derivatives
#' @inheritParams CPP_template
#'
#' @return Noting
#' @noRd
#'
NULL

#' Utility function to print likelihood and derivatives
#'
#' \code{Print_LL_Background} Called to print likelihood and derivatives for background model
#' @inheritParams CPP_template
#'
#' @return Noting
#' @noRd
#'
NULL

#' Utility function to perform calculation of terms and risks for Poisson Omnibus
#'
#' \code{Pois_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to perform calculation of Log-Likelihood and Deviation for Poisson Omnibus
#'
#' \code{Pois_Dev_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#' @param dev_temp temporary storage for deviation calculation
#' @param dev model deviation
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
NULL

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
NULL

#' Run a complete regression for a cox model
#'
#' \code{Cox_Full_Run} Called to perform one full regression
#' @inheritParams CPP_template
#'
#' @return Updates everything in place
#' @noRd
#'
NULL

#' Run a complete regression for a cox model
#'
#' \code{Pois_Full_Run} Called to perform one full regression
#' @inheritParams CPP_template
#'
#' @return Updates everything in place
#' @noRd
#'
NULL

#' Utility function to calculate Information Matrix, from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox} Called to update information matrix
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
NULL

#' Utility function to calculate Information Matrix with strata, from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_Strata} Called to update information matrix with strata
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
NULL

#' Utility function to calculate Information Matrix with competing risks, adapted from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_CR} Called to update information matrix with competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
NULL

#' Utility function to calculate Information Matrix with strata and competing risks, adapted from from Epicure manual
#'
#' \code{Expected_Inform_Matrix_Cox_Strata_CR} Called to update information matrix with strata and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: information matrix
#' @noRd
#'
NULL

#' Utility function to calculate poisson expected information matrix
#'
#' \code{Expected_Inform_Matrix_Poisson} Called to update information matrix
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to calculate logistic model expected information matrix
#'
#' \code{Expected_Inform_Matrix_Logist} Called to update information matrix
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
NULL

#' Utility function to apply a link function to a Logistic Regression Risk model
#'
#' \code{LinkCovertRP} Called to update the probability matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: p, 1-p, and the associated derivatives/ratios
#' @noRd
#'
NULL

#' Fills out recursive vectors for matched case-control logistic regression expected information matrix
#'
#' \code{Calc_Recursive_Exp} Called to update the recursive vectors, uses model_bool list to select which vectors to update.
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Fills out the expected information matrix for a case-control regression
#'
#' \code{Expected_Inform_Matrix_CaseCon} Called to update the expected information matrix
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Primary Cox PH baseline hazard function with stratification
#'
#' \code{PLOT_SURV_Strata} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
NULL

#' Primary Cox PH baseline hazard function
#'
#' \code{PLOT_SURV} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
NULL

#' Primary Cox PH schoenfeld residual function
#'
#' \code{Schoenfeld_Calc} Performs the calls to calculation functions, Uses calculated risks and risk groups to calculate the residuals, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: scaled schoenfeld residuals
#' @noRd
#'
NULL

#' Primary plotting function.
#'
#' \code{Plot_Omnibus} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Splits events into background and excess for a poisson regression
#'
#' \code{Assign_Events_Pois} Calculates proportion of events due to background and excess
#'
#' @inheritParams CPP_template
#'
#' @return returns proportion of events due to background and excess for each term
#' @noRd
#'
NULL

#' Primary plotting function.
#'
#' \code{Poisson_Residuals} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
NULL

#' Generates weightings for stratified poisson regression
#'
#' \code{Gen_Strat_Weight} Called from within c++, assigns vector of weights
#' @inheritParams CPP_template
#'
#' @return assigns weight in place and returns nothing
#' @noRd
#'
NULL

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_transition <- function(term_n, tform, a_ns, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_cox_ph_Omnibus_transition`, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the poisson omnibus regression function
#'
#' \code{pois_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_transition <- function(PyrC, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_pois_Omnibus_transition`, PyrC, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the event assignment omnibus function
#'
#' \code{Assigned_Event_transition} Called directly from R, Defines the control variables and calls the assigning functions
#' @inheritParams CPP_template
#'
#' @return list of assigned/predicted background/excess events
#' @noRd
#'
Assigned_Event_Poisson_transition <- function(PyrC, dfs, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, model_control) {
    .Call(`_Colossus_Assigned_Event_Poisson_transition`, PyrC, dfs, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, model_control)
}

#' Interface between R code and the plotting omnibus function
#'
#' \code{Plot_Omnibus_transition} Called directly from R, Defines the control variables and calls the plotting functions
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Plot_Omnibus_transition <- function(term_n, tform, a_n, dfc, df0, fir, der_iden, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control) {
    .Call(`_Colossus_Plot_Omnibus_transition`, term_n, tform, a_n, dfc, df0, fir, der_iden, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control)
}

#' Interface between R code and the Cox PH omnibus bounds regression function
#'
#' \code{cox_ph_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_Bounds_transition <- function(term_n, tform, a_n, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_cox_ph_Omnibus_Bounds_transition`, term_n, tform, a_n, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the Cox PH omnibus bounds regression function
#'
#' \code{cox_ph_Omnibus_CurveSearch_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_CurveSearch_transition <- function(term_n, tform, a_n, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_cox_ph_Omnibus_CurveSearch_transition`, term_n, tform, a_n, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the poisson omnibus bounds regression function
#'
#' \code{pois_Omnibus_CurveSearch_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_CurveSearch_transition <- function(PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_pois_Omnibus_CurveSearch_transition`, PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the poisson omnibus bounds regression function
#'
#' \code{pois_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_Bounds_transition <- function(PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_pois_Omnibus_Bounds_transition`, PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the poisson residual calculation function
#'
#' \code{pois_Residual_transition} Called directly from R, Defines the control variables and calls the calculation function
#' @inheritParams CPP_template
#'
#' @return Poisson_Residuals output : list of residuals and sum
#' @noRd
#'
pois_Residual_transition <- function(PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control) {
    .Call(`_Colossus_pois_Residual_transition`, PyrC, term_n, tform, a_n, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control)
}

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_multidose_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_multidose_Omnibus_transition <- function(term_n, tform, a_n, dose_cols, dose_index, dfc, df0, df1, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_cox_ph_multidose_Omnibus_transition`, term_n, tform, a_n, dose_cols, dose_index, dfc, df0, df1, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, cens_weight, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the poisson multidose omnibus regression function
#'
#' \code{pois_multidose_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Pois output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_multidose_Omnibus_transition <- function(PyrC, term_n, tform, a_n, dose_cols, dose_index, dfc, df0, df1, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_pois_multidose_Omnibus_transition`, PyrC, term_n, tform, a_n, dose_cols, dose_index, dfc, df0, df1, fir, modelform, Control, KeepConstant, term_tot, dfs, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the matched case-control omnibus regression function
#'
#' \code{caco_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_CaseCon_Omnibus output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
caco_Omnibus_transition <- function(term_n, tform, a_ns, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_caco_Omnibus_transition`, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, df_m, tu, KeepConstant, term_tot, Strata_vals, model_control, Lin_Sys, Lin_Res)
}

#' Interface between R code and the logistic omnibus regression function
#'
#' \code{logist_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
logist_Omnibus_transition <- function(CountEvent, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, model_control, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_logist_Omnibus_transition`, CountEvent, term_n, tform, a_ns, dfc, df0, fir, modelform, Control, KeepConstant, term_tot, model_control, Lin_Sys, Lin_Res)
}

#' Generates csv file with time-dependent columns
#'
#' \code{Write_Time_Dep} Called directly from R, Defines a new matrix which interpolates time-dependent values on a grid
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Write_Time_Dep <- function(df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads) {
    invisible(.Call(`_Colossus_Write_Time_Dep`, df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads))
}

#' Generates factored columns in parallel
#'
#' \code{Gen_Fac_Par} Called directly from R, returns a matrix with factored columns
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Gen_Fac_Par <- function(df0, vals, cols, nthreads) {
    .Call(`_Colossus_Gen_Fac_Par`, df0, vals, cols, nthreads)
}

#' Interface between R code and the risk check
#'
#' \code{cox_ph_transition_single} Called directly from R, Defines the control variables and calls the function which only calculates the log-likelihood
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
risk_check_transition <- function(term_n, tform, a_n, dfc, df0, fir, modelform, Control, model_control, KeepConstant, term_tot) {
    .Call(`_Colossus_risk_check_transition`, term_n, tform, a_n, dfc, df0, fir, modelform, Control, model_control, KeepConstant, term_tot)
}

#' Checks the OMP flag
#'
#' \code{OMP_Check} Called directly from R, checks the omp flag and returns true if omp is enabled
#'
#' @return boolean: True for OMP allowed
#'
OMP_Check <- function() {
    .Call(`_Colossus_OMP_Check`)
}

#' Utility function to keep intercept parameters within the range of possible values
#'
#' \code{Intercept_Bound} Called to update the parameter list in the event that intercepts leave the bounds of possible values
#' @inheritParams CPP_template
#'
#' @return Updates vector in place: parameter vector
#' @noRd
#'
NULL

#' Utility function to calculate steps for a likelihood based bound
#'
#' \code{Log_Bound} Called to perform likelihood bound steps
#' @inheritParams CPP_template
#' @param Lstar likelihood goal
#' @param L0 current likelihood
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change_trouble} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration with gradient step
#'
#' \code{Calc_Change_Gradient} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies gradient normalization and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration with gradient step following a linear constraint
#'
#' \code{Calc_Change_Gradient_Cons} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies gradient normalization and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration with gradient step and background terms
#'
#' \code{Calc_Change_Background_Gradient} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies gradient normalization and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration, applying linear constraints
#'
#' \code{Calc_Change_Cons} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations with a system of constraints
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration, with basic model
#'
#' \code{Calc_Change_Basic} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration, with basic model and constraints added
#'
#' \code{Calc_Change_Basic_Cons} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the change to make each iteration, applies to background terms as well
#'
#' \code{Calc_Change_Background} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
NULL

#' Utility function to calculate the term and subterm values
#'
#' \code{Make_subterms} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
NULL

#' Utility function to calculate the term and subterm values with gradient method
#'
#' \code{Make_subterms_Gradient} Called to update term matrices, Uses lists of term numbers and types to apply formulas, gradient method
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
NULL

#' Utility function to calculate the term and subterm values, but not derivatives
#'
#' \code{Make_subterms_Single} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
NULL

#' Utility function to calculate the term and subterm values with the basic model
#'
#' \code{Make_subterms_Basic} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
NULL

#' Utility function to calculate the term and subterm values
#'
#' \code{Make_subterms_Linear_ERR} Called to update subterms for Linear ERR simplification
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios
#'
#' \code{Make_Risks} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios for gradient method
#'
#' \code{Make_Risks_Gradient} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas for gradient method
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios with a weighting applied
#'
#' \code{Make_Risks_Weighted} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios with a weighting applied and gradient method
#'
#' \code{Make_Risks_Weighted_Gradient} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk with a weighting applied and no derivatives calculated
#'
#' \code{Make_Risks_Weighted_Single} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk, but not derivatives
#'
#' \code{Make_Risks_Single} Called to update risk matrices, Splits into cases based on model form
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios for the basic model
#'
#' \code{Make_Risks_Basic} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

#' Utility function to calculate the risk and risk ratios
#'
#' \code{Make_Risks_Linear_ERR} Called to update risk matrices, uses the Linear ERR simplification
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
NULL

