/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.gui.DynamicUIManagerListener;

public class DynamicUIManager {
    private static final DynamicUIManager instance = new DynamicUIManager();
    private ArrayList listeners = new ArrayList(2);
    private ArrayList prioritizedListeners = new ArrayList(2);
    private String[] properties = new String[]{"win.3d.backgroundColor", "win.3d.highlightColor", "win.3d.lightColor", "win.3d.shadowColor", "win.frame.activeCaptionColor", "win.frame.activeCaptionGradientColor", "win.frame.captionTextColor", "win.frame.activeBorderColor", "win.mdi.backgroundColor", "win.desktop.backgroundColor", "win.frame.inactiveCaptionColor", "win.frame.inactiveCaptionGradientColor", "win.frame.inactiveCaptionTextColor", "win.frame.inactiveBorderColor", "win.menu.backgroundColor", "win.menu.textColor", "win.frame.textColor?????", "win.item.highlightColor", "win.item.highlightTextColor", "win.tooltip.backgroundColor", "win.tooltip.textColor", "win.frame.backgroundColor", "win.frame.textColor", "win.item.hotTrackedColor"};
    private Toolkit currentToolkit;
    private boolean propertyChangePending;

    public static DynamicUIManager getInstance() {
        return instance;
    }

    private DynamicUIManager() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DynamicUIManager.this.handlePropertyChanges();
            }
        };
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    DynamicUIManager.this.setupPropertyListener(propertyChangeListener);
                    DynamicUIManager.this.fireLookAndFeelChanging();
                    DynamicUIManager.this.fireLookAndFeelChanged();
                }
            }
        });
        UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!(propertyChangeEvent.getNewValue() instanceof Class)) {
                    DynamicUIManager.this.handlePropertyChanges();
                }
            }
        });
        this.setupPropertyListener(propertyChangeListener);
    }

    private void setupPropertyListener(PropertyChangeListener propertyChangeListener) {
        int n;
        if (this.currentToolkit != null) {
            for (n = 0; n < this.properties.length; ++n) {
                this.currentToolkit.removePropertyChangeListener(this.properties[n], propertyChangeListener);
            }
        }
        this.currentToolkit = Toolkit.getDefaultToolkit();
        for (n = 0; n < this.properties.length; ++n) {
            this.currentToolkit.addPropertyChangeListener(this.properties[n], propertyChangeListener);
        }
    }

    public void addListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.listeners.add(dynamicUIManagerListener);
    }

    public void removeListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.listeners.remove(dynamicUIManagerListener);
    }

    public void addPrioritizedListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.prioritizedListeners.add(dynamicUIManagerListener);
    }

    public void removePrioritizedListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.prioritizedListeners.remove(dynamicUIManagerListener);
    }

    private void fireLookAndFeelChanging() {
        int n;
        Object[] objectArray = this.prioritizedListeners.toArray();
        Object[] objectArray2 = this.listeners.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            ((DynamicUIManagerListener)objectArray[n]).lookAndFeelChanging();
        }
        for (n = 0; n < objectArray2.length; ++n) {
            ((DynamicUIManagerListener)objectArray2[n]).lookAndFeelChanging();
        }
    }

    private void fireLookAndFeelChanged() {
        int n;
        Object[] objectArray = this.prioritizedListeners.toArray();
        Object[] objectArray2 = this.listeners.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            ((DynamicUIManagerListener)objectArray[n]).lookAndFeelChanged();
        }
        for (n = 0; n < objectArray2.length; ++n) {
            ((DynamicUIManagerListener)objectArray2[n]).lookAndFeelChanged();
        }
    }

    private void handlePropertyChanges() {
        if (!this.propertyChangePending) {
            this.propertyChangePending = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DynamicUIManager.this.propertyChangePending = false;
                    DynamicUIManager.this.firePropertyChanged();
                }
            });
            this.firePropertyChanging();
        }
    }

    private void firePropertyChanging() {
        int n;
        Object[] objectArray = this.prioritizedListeners.toArray();
        Object[] objectArray2 = this.listeners.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            ((DynamicUIManagerListener)objectArray[n]).propertiesChanging();
        }
        for (n = 0; n < objectArray2.length; ++n) {
            ((DynamicUIManagerListener)objectArray2[n]).propertiesChanging();
        }
    }

    private void firePropertyChanged() {
        int n;
        Object[] objectArray = this.prioritizedListeners.toArray();
        Object[] objectArray2 = this.listeners.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            ((DynamicUIManagerListener)objectArray[n]).propertiesChanged();
        }
        for (n = 0; n < objectArray2.length; ++n) {
            ((DynamicUIManagerListener)objectArray2[n]).propertiesChanged();
        }
    }
}

