/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class OpenContentBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ColorProvider topLeftLineColor;
    private final ColorProvider bottomRightLineColor;
    private final ColorProvider highlightColorProvider;
    private int tabLeftInset = 1;

    public OpenContentBorder(Color color, int n) {
        this(color);
        this.tabLeftInset = n;
    }

    public OpenContentBorder() {
        this(null);
    }

    public OpenContentBorder(Color color) {
        this(color, null);
    }

    public OpenContentBorder(Color color, Color color2) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW), color2 == null ? null : new FixedColorProvider(color2), 1);
    }

    public OpenContentBorder(ColorProvider colorProvider, ColorProvider colorProvider2, int n) {
        this(colorProvider, colorProvider, colorProvider2, n);
    }

    public OpenContentBorder(ColorProvider colorProvider, ColorProvider colorProvider2, ColorProvider colorProvider3, int n) {
        this.topLeftLineColor = colorProvider;
        this.bottomRightLineColor = colorProvider2;
        this.highlightColorProvider = colorProvider3;
        this.tabLeftInset = n;
    }

    private static int getLineIntersection(int n, float f, float f2, float f3, float f4, Direction direction) {
        return direction.isHorizontal() ? (f <= (float)n && f3 >= (float)n || f >= (float)n && f3 <= (float)n ? Math.round(f3 == f ? f4 : f2 + ((float)n - f) * (f4 - f2) / (f3 - f)) : Integer.MAX_VALUE) : (f2 <= (float)n && f4 >= (float)n || f2 >= (float)n && f4 <= (float)n ? Math.round(f4 == f2 ? f3 : f + ((float)n - f2) * (f3 - f) / (f4 - f2)) : Integer.MAX_VALUE);
    }

    private static Point getTabBounds(Component component, Tab tab, Direction direction, int n, int n2, int n3, int n4) {
        Rectangle rectangle = tab.getVisibleRect();
        rectangle = SwingUtilities.convertRectangle(tab, rectangle, component);
        int n5 = direction.isHorizontal() ? Math.max(n2, rectangle.y) : Math.max(n, rectangle.x);
        int n6 = n5 + (direction.isHorizontal() ? rectangle.height : rectangle.width) - 1;
        Shape shape = tab.getShape();
        if (shape != null) {
            int n7 = direction == Direction.UP ? tab.getHeight() : (direction == Direction.RIGHT ? -1 : (direction == Direction.DOWN ? -1 : tab.getWidth()));
            float[] fArray = new float[6];
            PathIterator pathIterator = shape.getPathIterator(null);
            pathIterator.currentSegment(fArray);
            pathIterator.next();
            float f = fArray[0];
            float f2 = fArray[1];
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MIN_VALUE;
            while (!pathIterator.isDone()) {
                float f3 = fArray[0];
                float f4 = fArray[1];
                pathIterator.currentSegment(fArray);
                int n10 = OpenContentBorder.getLineIntersection(n7, f3, f4, fArray[0], fArray[1], direction);
                if (n10 != Integer.MAX_VALUE) {
                    if (n10 < n8) {
                        n8 = n10;
                    }
                    if (n10 > n9) {
                        n9 = n10;
                    }
                }
                pathIterator.next();
            }
            int n11 = OpenContentBorder.getLineIntersection(n7, fArray[0], fArray[1], f, f2, direction);
            if (n11 != Integer.MAX_VALUE) {
                if (n11 < n8) {
                    n8 = n11;
                }
                if (n11 > n9) {
                    n9 = n11;
                }
            }
            Point point = SwingUtilities.convertPoint(tab, 0, 0, component);
            if (direction.isHorizontal()) {
                n8 += point.y;
                n9 += point.y;
            } else {
                n8 += point.x;
                n9 += point.x;
            }
            n5 = Math.max(n5, n8);
            n6 = Math.min(n6, n9);
        }
        return new Point(n5, n6);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanelContentPanel(component).getTabbedPanel();
        if (component != null && tabbedPanel != null) {
            Color color;
            Serializable serializable;
            Serializable serializable2;
            Tab tab = tabbedPanel.getHighlightedTab();
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
            if (tab != null) {
                serializable2 = OpenContentBorder.getTabBounds(component, tab, direction, n, n2, n3, n4);
                n5 = ((Point)serializable2).x;
                n6 = ((Point)serializable2).y;
                serializable = tab.getVisibleRect();
                int n8 = (int)((Rectangle)serializable).getWidth();
                int n9 = (int)((Rectangle)serializable).getHeight();
                n7 = (direction.isHorizontal() ? tab.getHeight() > n9 : tab.getWidth() > n8) ? -1 : 0;
            }
            serializable2 = this.topLeftLineColor != null ? this.topLeftLineColor.getColor(component) : null;
            serializable = this.bottomRightLineColor != null ? this.bottomRightLineColor.getColor(component) : null;
            Color color2 = color = this.highlightColorProvider == null ? null : this.highlightColorProvider.getColor(component);
            if (direction == Direction.UP && tab != null) {
                if (serializable2 != null) {
                    graphics.setColor((Color)serializable2);
                    OpenContentBorder.drawLine(graphics, n, n2, n5 - 1 + this.tabLeftInset, n2);
                    OpenContentBorder.drawLine(graphics, n6 - n7, n2, n + n3 - 1, n2);
                }
                if (this.highlightColorProvider != null) {
                    graphics.setColor(color);
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + 1, n5 + this.tabLeftInset - 1, n2 + 1);
                    if (n6 > n5) {
                        OpenContentBorder.drawLine(graphics, n5 + this.tabLeftInset, n2, n5 + this.tabLeftInset, n2 + 1);
                    }
                    OpenContentBorder.drawLine(graphics, n6, n2 + 1, n + n3 - 3, n2 + 1);
                }
            } else {
                if (serializable2 != null) {
                    graphics.setColor((Color)serializable2);
                    OpenContentBorder.drawLine(graphics, n, n2, n + n3 - 1, n2);
                }
                if (this.highlightColorProvider != null) {
                    graphics.setColor(color);
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + 1, n + n3 - (direction == Direction.RIGHT && n5 == 0 ? 1 : 3), n2 + 1);
                }
            }
            if (direction == Direction.LEFT && tab != null) {
                if (serializable2 != null) {
                    graphics.setColor((Color)serializable2);
                    OpenContentBorder.drawLine(graphics, n, n2 + 1, n, n5 - 1 + this.tabLeftInset);
                    OpenContentBorder.drawLine(graphics, n, n6 - n7, n, n2 + n4 - 1);
                }
                if (this.highlightColorProvider != null) {
                    graphics.setColor(color);
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + 2, n + 1, n5 + this.tabLeftInset - 1);
                    if (n6 > n5) {
                        OpenContentBorder.drawLine(graphics, n, n5 + this.tabLeftInset, n + 1, n5 + this.tabLeftInset);
                    }
                    OpenContentBorder.drawLine(graphics, n + 1, n6, n + 1, n2 + n4 - 3);
                }
            } else {
                if (serializable2 != null) {
                    graphics.setColor((Color)serializable2);
                    OpenContentBorder.drawLine(graphics, n, n2 + 1, n, n2 + n4 - 1);
                }
                if (this.highlightColorProvider != null) {
                    graphics.setColor(color);
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + 2, n + 1, n2 + n4 - (direction == Direction.DOWN && n5 == 0 ? 1 : 3));
                }
            }
            if (serializable != null) {
                graphics.setColor((Color)serializable);
                if (direction == Direction.RIGHT && tab != null) {
                    OpenContentBorder.drawLine(graphics, n + n3 - 1, n2 + 1, n + n3 - 1, n5 - 1 + this.tabLeftInset);
                    OpenContentBorder.drawLine(graphics, n + n3 - 1, n6 - n7, n + n3 - 1, n2 + n4 - 1);
                } else {
                    OpenContentBorder.drawLine(graphics, n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                }
                if (direction == Direction.DOWN && tab != null) {
                    graphics.setColor((Color)serializable);
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + n4 - 1, n5 - 1 + this.tabLeftInset, n2 + n4 - 1);
                    OpenContentBorder.drawLine(graphics, n6 - n7, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                } else {
                    OpenContentBorder.drawLine(graphics, n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                }
            }
        }
    }

    private static void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 < n || n4 < n2) {
            return;
        }
        GraphicsUtil.drawOptimizedLine(graphics, n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        int n = this.highlightColorProvider != null ? 1 : 0;
        int n2 = (this.topLeftLineColor != null ? 1 : 0) + n;
        int n3 = this.bottomRightLineColor != null ? 1 : 0;
        return new Insets(n2, n2, n3, n3);
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

