/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class CursorManager {
    private static boolean enabled = true;
    private static WeakHashMap windowPanels = new WeakHashMap();

    private CursorManager() {
    }

    public static void setGlobalCursor(final JRootPane jRootPane, Cursor cursor) {
        if (jRootPane == null) {
            return;
        }
        RootCursorInfo rootCursorInfo = (RootCursorInfo)windowPanels.get(jRootPane);
        if (rootCursorInfo == null) {
            rootCursorInfo = new RootCursorInfo(new JComponent(){});
            windowPanels.put(jRootPane, rootCursorInfo);
            jRootPane.getLayeredPane().add(rootCursorInfo.getComponent());
            jRootPane.getLayeredPane().setLayer(rootCursorInfo.getComponent(), JLayeredPane.DRAG_LAYER + 10);
            rootCursorInfo.getComponent().setBounds(0, 0, jRootPane.getWidth(), jRootPane.getHeight());
            jRootPane.getLayeredPane().addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    ((RootCursorInfo)windowPanels.get(jRootPane)).getComponent().setSize(jRootPane.getSize());
                }
            });
        }
        if (!rootCursorInfo.isCursorSet()) {
            rootCursorInfo.setCursor(cursor);
            rootCursorInfo.pushCursor(jRootPane.isCursorSet() ? jRootPane.getCursor() : null);
        }
        if (enabled) {
            jRootPane.setCursor(cursor);
            rootCursorInfo.getComponent().setVisible(true);
        }
    }

    public static Cursor getCurrentGlobalCursor(JRootPane jRootPane) {
        if (jRootPane == null) {
            return Cursor.getDefaultCursor();
        }
        RootCursorInfo rootCursorInfo = (RootCursorInfo)windowPanels.get(jRootPane);
        return rootCursorInfo == null || !rootCursorInfo.isCursorSet() ? Cursor.getDefaultCursor() : rootCursorInfo.getCursor();
    }

    public static void resetGlobalCursor(JRootPane jRootPane) {
        if (jRootPane == null) {
            return;
        }
        RootCursorInfo rootCursorInfo = (RootCursorInfo)windowPanels.get(jRootPane);
        if (rootCursorInfo != null && rootCursorInfo.isCursorSet()) {
            jRootPane.setCursor(rootCursorInfo.popCursor());
            rootCursorInfo.getComponent().setVisible(false);
        }
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static JComponent getCursorLayerComponent(JRootPane jRootPane) {
        if (jRootPane == null) {
            return null;
        }
        RootCursorInfo rootCursorInfo = (RootCursorInfo)windowPanels.get(jRootPane);
        return rootCursorInfo == null ? null : rootCursorInfo.getComponent();
    }

    public static boolean isGlobalCursorSet(JRootPane jRootPane) {
        if (jRootPane == null) {
            return false;
        }
        RootCursorInfo rootCursorInfo = (RootCursorInfo)windowPanels.get(jRootPane);
        return rootCursorInfo != null && rootCursorInfo.isCursorSet();
    }

    private static class RootCursorInfo {
        private Cursor savedCursor;
        private Cursor cursor;
        private JComponent panel;
        private boolean cursorSet = false;

        RootCursorInfo(JComponent jComponent) {
            this.panel = jComponent;
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public void pushCursor(Cursor cursor) {
            if (this.savedCursor == null) {
                this.savedCursor = cursor;
            }
            this.cursorSet = true;
        }

        public Cursor popCursor() {
            Cursor cursor = this.savedCursor;
            this.savedCursor = null;
            this.cursorSet = false;
            return cursor;
        }

        public boolean isCursorSet() {
            return this.cursorSet;
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public void setCursor(Cursor cursor) {
            this.cursor = cursor;
        }
    }
}

