/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.internal.TwoColoredLineBorder;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;

public class ClassicTheme
extends TabbedPanelTitledTabTheme {
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();
    private ColorProvider highlightColor = UIManagerColorProvider.TABBED_PANE_HIGHLIGHT;
    private ColorProvider shadowColor = UIManagerColorProvider.TABBED_PANE_SHADOW;
    private ColorProvider darkShadow = UIManagerColorProvider.TABBED_PANE_DARK_SHADOW;
    private int raised;
    private Border shadowBorder;

    public ClassicTheme() {
        this(2);
    }

    public ClassicTheme(int n) {
        this.raised = n;
        this.shadowBorder = new Border(){

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
                if (tabbedPanel != null) {
                    Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
                    graphics.setColor(ClassicTheme.this.shadowColor.getColor());
                    if (direction == Direction.UP || direction == Direction.DOWN) {
                        GraphicsUtil.drawOptimizedLine(graphics, n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                    } else {
                        GraphicsUtil.drawOptimizedLine(graphics, n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    }
                }
            }

            public Insets getBorderInsets(Component component) {
                TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
                if (tabbedPanel != null) {
                    Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
                    return new Insets(0, 0, direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : 0, direction == Direction.UP || direction == Direction.DOWN ? 1 : 0);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
        CompoundBorder compoundBorder = new CompoundBorder(new OpenContentBorder(this.highlightColor, this.darkShadow, null, 1), new OpenContentBorder(null, this.shadowColor, null, 1));
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder(compoundBorder).setInsets(new Insets(1, 1, 1, 1));
        this.tabbedPanelProperties.setTabSpacing(-n - 1).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getComponentProperties().setBorder(this.doCreateTabBorder(false, false, true, true));
        Border border = this.createInsetsTabBorder(true, true, false);
        Border border2 = this.doCreateTabBorder(true, true, true, false);
        Insets insets = new Insets(0, 3, 0, 3);
        Insets insets2 = new Insets(0, (n + 1) / 2 + ((n + 1 & 1) == 1 ? 1 : 0) + insets.left, 1, (n + 1) / 2 + insets.right);
        this.titledTabProperties.setHighlightedRaised(n).setBorderSizePolicy(TitledTabBorderSizePolicy.INDIVIDUAL_SIZE);
        this.titledTabProperties.getNormalProperties().getComponentProperties().setBorder(border).setInsets(insets);
        this.titledTabProperties.getHighlightedProperties().getComponentProperties().setBorder(border2).setInsets(insets2);
    }

    public String getName() {
        return "Classic Theme";
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public Border createInsetsTabBorder(boolean bl, boolean bl2, boolean bl3) {
        Border border = new Border(){

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            }

            public Insets getBorderInsets(Component component) {
                TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
                if (tabbedPanel != null) {
                    Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
                    return new Insets(direction == Direction.RIGHT || direction == Direction.LEFT ? ClassicTheme.this.raised : 0, direction == Direction.UP || direction == Direction.DOWN ? ClassicTheme.this.raised : 0, direction == Direction.RIGHT || direction == Direction.LEFT ? 1 : 0, direction == Direction.UP || direction == Direction.DOWN ? 1 : 0);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
        return new CompoundBorder(border, this.doCreateTabBorder(bl, bl2, bl3, true));
    }

    public Border createTabBorder(boolean bl, boolean bl2, boolean bl3) {
        return this.doCreateTabBorder(bl, bl2, true, bl3);
    }

    private ColorProvider createNormalHighlightColorProvider() {
        return new ColorProvider(){

            public Color getColor() {
                Color color = TabbedUIDefaults.getHighlightedStateBackground();
                color = new Color(color.getRed() == 0 ? 1 : color.getRed(), color.getGreen() == 0 ? 1 : color.getGreen(), color.getBlue() == 0 ? 1 : color.getBlue());
                Color color2 = TabbedUIDefaults.getNormalStateBackground();
                Color color3 = ClassicTheme.this.highlightColor.getColor();
                int n = (int)((float)color2.getRed() * ((float)color3.getRed() / (float)color.getRed()));
                int n2 = (int)((float)color2.getGreen() * ((float)color3.getGreen() / (float)color.getGreen()));
                int n3 = (int)((float)color2.getBlue() * ((float)color3.getBlue() / (float)color.getBlue()));
                n = (n + color3.getRed()) / 2;
                n2 = (n2 + color3.getGreen()) / 2;
                n3 = (n3 + color3.getBlue()) / 2;
                return new Color(n > 255 ? 255 : n, n2 > 255 ? 255 : n2, n3 > 255 ? 255 : n3);
            }

            public Color getColor(Component component) {
                return this.getColor();
            }
        };
    }

    private Border doCreateTabBorder(boolean bl, boolean bl2, boolean bl3, final boolean bl4) {
        return new CompoundBorder(new TwoColoredLineBorder(bl3 ? this.highlightColor : this.createNormalHighlightColorProvider(), this.darkShadow, bl, bl2){

            protected Insets getShapedBorderInsets(Component component) {
                return bl4 ? new Insets(1, 1, 1, 1) : super.getShapedBorderInsets(component);
            }
        }, this.shadowBorder);
    }
}

