/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.infonode.util.Direction;

class PanePainter
extends JTabbedPane {
    private boolean mouseEntered = false;
    private boolean focusActive = false;
    private boolean useMouseEnterExit = false;
    private Direction direction;

    PanePainter(Direction direction) {
        this.setTabPlacement(direction);
        this.setTabLayoutPolicy(0);
        boolean bl = this.useMouseEnterExit = UIManager.getLookAndFeel().getClass().getName().indexOf(".LiquidLookAndFeel") > -1;
        if (!this.useMouseEnterExit) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }
    }

    void setTabAreaEntered(boolean bl) {
        if (bl) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        } else {
            super.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
        }
    }

    private void setTabPlacement(Direction direction) {
        this.direction = direction;
        if (direction == Direction.UP) {
            this.setTabPlacement(1);
        } else if (direction == Direction.LEFT) {
            this.setTabPlacement(2);
        } else if (direction == Direction.RIGHT) {
            this.setTabPlacement(4);
        } else {
            this.setTabPlacement(3);
        }
    }

    void setMouseEntered(boolean bl) {
        if (this.useMouseEnterExit) {
            if (bl && !this.mouseEntered) {
                super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
            } else if (!bl && this.mouseEntered) {
                super.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
            }
        } else if (!bl && this.mouseEntered) {
            super.processMouseMotionEvent(new MouseEvent(this, 503, System.currentTimeMillis(), 0, -1, -1, 0, false));
        }
        this.mouseEntered = bl;
    }

    void setHoveredTab(int n) {
        if (n > -1 && n < this.getTabCount()) {
            Rectangle rectangle = this.getBoundsAt(n);
            int n2 = rectangle.x + rectangle.width / 2;
            int n3 = rectangle.y + rectangle.height / 2;
            super.processMouseMotionEvent(new MouseEvent(this, 503, System.currentTimeMillis(), 0, n2, n3, 0, false));
        }
    }

    void setFocusActive(boolean bl) {
        if (bl && !this.focusActive) {
            super.processFocusEvent(new FocusEvent(this, 1004));
        } else if (!bl && this.focusActive) {
            super.processFocusEvent(new FocusEvent(this, 1005));
        }
        this.focusActive = bl;
    }

    Direction getDirection() {
        return this.direction;
    }

    void doValidation() {
        for (Container container = this; container != null; container = container.getParent()) {
            ((Component)container).invalidate();
        }
        this.validate();
    }

    void removeAllTabs() {
        this.removeAll();
        this.doValidation();
    }

    public Font getFont() {
        Font font = UIManager.getFont("TabbedPane.font");
        return font == null ? super.getFont() : font;
    }

    public void updateUI() {
        this.setBorder(null);
        this.setBackground(null);
        this.setForeground(null);
        this.setOpaque(false);
        super.updateUI();
        this.setTabLayoutPolicy(0);
        boolean bl = this.useMouseEnterExit = UIManager.getLookAndFeel().getClass().getName().indexOf(".LiquidLookAndFeel") > -1;
        if (!this.useMouseEnterExit) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }
    }

    public boolean hasFocus() {
        return this.focusActive;
    }

    public void repaint() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    void paint(Graphics graphics, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0) {
            return;
        }
        graphics.translate(n, n2);
        this.update(graphics);
        graphics.translate(-n, -n2);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
    }
}

