% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{coef.GIC.FuncompCGL}
\alias{coef.GIC.FuncompCGL}
\title{Extract model estimated coefficients from a \code{"GIC.FuncompCGL"} object.}
\usage{
\method{coef}{GIC.FuncompCGL}(object, s = "lam.min", k = NULL, ...)
}
\arguments{
\item{object}{fitted \code{\link{GIC.FuncompCGL}} object.}

\item{s}{value(s) of the regularization parameter \code{lam} at which coefficients are requested.
\itemize{
\item \code{s="lam.min"} (default), grid value of \code{lam} and \code{k} stored in
      \code{"GIC.FuncompCGL"} object such that the minimun value of GIC is achieved.
\item If \code{s} is numeric, it is taken as the value(s) of \code{lam} to be used.
      In this case, k must be provided.
\item If \code{s = NULL}, used the whole sequence of \code{lam} stored in the \code{GIC.FuncompCGL}
      object.
}}

\item{k}{value(s) of degrees of freedom of the basis function at which coefficents are requested.
\code{k} can be \code{NULL} (default) or integer(s).
\itemize{
\item \code{k = NULL}, \code{s} must be \code{"lam.min"}.
\item if \code{k} is integer(s), it is taken as the value of \code{k} to be used
      and it must be one(s) of these in \code{"GIC.FuncompCGL"} model.
}}

\item{\dots}{not used.}
}
\value{
The coefficients at the requested tuning parameter values in \code{s}.
}
\description{
This function gets coefficients from a \code{"GIC.FuncompCGL"} object,
using the stored \code{"FuncompCGL.fit"} object, and the optimal values of
\code{lam} and \code{k}.
}
\details{
\code{s} is a vector of lambda values at which the coefficients are requested. If \code{s} is not in the
\code{lam} sequence used for fitting the model, the \code{coef} function will use linear
interpolation, so the function should be used with caution.
}
\examples{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
n = 50
k_list <- c(4,5)
Data <- Fcomp_Model(n = n, p = p, m = 0, intercept = TRUE,
                    SNR = 4, sigma = 3, rho_X = 0.6, rho_T = 0,
                    df_beta = df_beta, n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))

GIC_m1 <-  GIC.FuncompCGL(y = Data$data$y, X = Data$data$Comp,
                          Zc = Data$data$Zc, intercept = Data$data$intercept,
                          k = k_list)
coef(GIC_m1)
coef(GIC_m1, s = c(0.05, 0.01), k = c(4,5))
coef(GIC_m1, s = NULL, k = c(4,5))

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{GIC.FuncompCGL}} and \code{\link{FuncompCGL}}, and
\code{\link[=predict.GIC.FuncompCGL]{predict}} and
\code{\link[=plot.GIC.FuncompCGL]{plot}} methods for \code{"GIC.FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
