% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.R
\name{upset}
\alias{upset}
\title{Compose an UpSet plot}
\usage{
upset(
  data,
  intersect,
  base_annotations = list(`Intersection size` = intersection_size(counts = TRUE)),
  name = "group",
  annotations = list(),
  themes = upset_themes,
  stripes = upset_stripes,
  labeller = identity,
  height_ratio = 0.5,
  width_ratio = 0.3,
  wrap = FALSE,
  set_sizes = upset_set_size(width = 0.6),
  queries = list(),
  dot_size = 3,
  ...
)
}
\arguments{
\item{data}{a dataframe including binary columns representing membership in classes}

\item{intersect}{which columns should be used to compose the intersection}

\item{base_annotations}{a named list with default annotations (i.e. the intersection size barplot)}

\item{name}{the label shown below the intersection matrix}

\item{annotations}{a named list of annotations, each being a list with: \verb{list(aes=mapping, geom=geom or list of geoms)};
\itemize{
\item (optional) \verb{highlight_geom=list of geoms} geoms which can be highlighted with queries,
\item (optional) \verb{top_geom=list of geoms} which should show up on top of highlighted queries.
}}

\item{themes}{a named list of themes for components and annotations, see \code{upset_default_themes()}/\code{upset_modify_themes()}}

\item{stripes}{a characters vector, specifying the background colors for rows (e.g. odd and even if two elements)}

\item{labeller}{function modifying the names of the sets (rows in the matrix)}

\item{height_ratio}{ratio of the intersection matrix to intersection size height}

\item{width_ratio}{ratio of the overall set size width to intersection matrix width}

\item{wrap}{whether the plot should be wrapped into a group (makes adding a tile/combining with other plots easier)}

\item{set_sizes}{a list of layers defining the overall set sizes, e.g. from \code{upset_set_size()} (\code{FALSE} to hide)}

\item{queries}{a list of queries generated with \code{upset_query()}}

\item{dot_size}{size of the points on the intersection matrix}

\item{...}{
  Arguments passed on to \code{\link[=upset_data]{upset_data}}
  \describe{
    \item{\code{min_size}}{minimal number of observations in an intersection for it to be included}
    \item{\code{max_size}}{maximal number of observations in an intersection for it to be included}
    \item{\code{min_degree}}{minimal degree of an intersection for it to be included}
    \item{\code{max_degree}}{maximal degree of an intersection for it to be included}
    \item{\code{n_intersections}}{the exact number of the intersections to be displayed; n largest intersections that meet the size and degree criteria will be shown}
    \item{\code{keep_empty_groups}}{whether empty sets should be kept (including sets which are only empty after filtering by size)}
    \item{\code{warn_when_dropping_groups}}{whether a warning should be issued when empty sets are being removed}
    \item{\code{warn_when_converting}}{whether a warning should  be issued when input is not boolean}
    \item{\code{sort_sets}}{whether to sort the rows in the intersection matrix (descending sort by default); one of: \code{'ascending'}, \code{'descending'}, \code{FALSE}}
    \item{\code{sort_intersections}}{whether to sort the columns in the intersection matrix (descending sort by default); one of: \code{'ascending'}, \code{'descending'}, \code{FALSE}}
    \item{\code{sort_intersections_by}}{the mode of sorting, the size of the intersection (cardinality) by default; one of: \code{'cardinality'}, \code{'degree'}, \code{'ratio'}}
    \item{\code{group_by}}{the mode of grouping intersections; one of: \code{'degree'}, \code{'sets'}}
    \item{\code{min_max_early}}{whether the min and max limits should be applied early (for faster plotting), or late (for accurate depiction of ratios)}
    \item{\code{union_count_column}}{name of the column to store the union size (adjust if conflicts with your data)}
    \item{\code{intersection_count_column}}{name of the column to store the intersection size (adjust if conflicts with your data)}
  }}
}
\description{
Compose an UpSet plot
}
