% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{compare_between_intersections}
\alias{compare_between_intersections}
\title{Compare covariates between intersections}
\usage{
compare_between_intersections(
  data,
  intersect,
  test = kruskal.test,
  tests = list(),
  ignore = list(),
  ignore_mode_columns = TRUE,
  mode = "exclusive_intersection",
  ...
)
}
\arguments{
\item{data}{a dataframe including binary columns representing membership in classes}

\item{intersect}{which columns should be used to compose the intersection}

\item{test}{the default test function; it is expected to accept \code{formula} and \code{data} parameters, and a list with \code{p.value}, \code{statistic}, and \code{method}}

\item{tests}{a named list with tests for specific variables, overwriting the default test}

\item{ignore}{a list with names of variables to exclude from testing}

\item{ignore_mode_columns}{whether the membership columns and size columns for all modes should be ignored}

\item{mode}{region selection mode; note that modes other than \code{exclusive_intersection} repeat observations in different test group, introducing dependencies. See \code{get_size_mode()} for accepted values.}

\item{...}{passed to \code{upset_data()}}
}
\description{
Compare covariates between intersections
}
