% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Density_Plot}
\alias{CT_Density_Plot}
\title{Density Plot from the Concordance Coefficient and Kruskal Wallis Normalized Statistics}
\usage{
CT_Density_Plot(C_freq = NULL, H_freq = NULL)
}
\arguments{
\item{C_freq}{Frecuency and probability distribution of Concordance Coefficient obtained from the functions: \code{\link{CT_Distribution}}, \code{\link{CT_Distribution_Sim}}.}

\item{H_freq}{Frecuency and probability distribution of Kruskal Wallis statistic obtained from the functions: \code{\link{CT_Distribution}}, \code{\link{CT_Distribution_Sim}}.}
}
\description{
This function performs the graphical visualization of the density distribution of Concordance Coefficient and Kruskal Wallis Statistic.
}
\examples{
Sample_Sizes <- c(5,4)
Distributions <-  CT_Distribution(Sample_Sizes, H = 1)
C_freq <- Distributions$C_freq
H_freq <- Distributions$H_freq
CT_Density_Plot(C_freq, H_freq)


Sample_Sizes <- c(5,5,5)
Distributions <-  CT_Distribution_Sim(Sample_Sizes, Num_Sim = 1000, H = 1)
C_freq <- Distributions$C_freq
H_freq <- Distributions$H_freq
CT_Density_Plot(C_freq, H_freq)
}
