% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Distribution}
\alias{CT_Distribution}
\title{Probability Distribution of Concordance Coefficient and Kruskal Wallis Statistic}
\usage{
CT_Distribution(Sample_Sizes, H = 0)
}
\arguments{
\item{Sample_Sizes}{Numeric vector (\code{n1},...,\code{nk}) containing the number of repetitions of each element, i.e., the size of each sample in the experiment.}

\item{H}{0 by default. If set to 1, the probability distribution table of Kruskal-Wallis Statistic is also calculated and returned.}
}
\value{
The function returns a list with the following elements:
\enumerate{
 \item{ \code{C_freq}: Matrix with the probability distribution of Concordance Coefficient. Each row in the matrix contains the disorder, the value of the statistic, the frequency and its probability.}
 \item{ \code{H_freq}: Matrix with the probability distribution of Kruskal Wallis Statistic. Each row in the matrix contains the value of the statistic, the frequency and its probability (only if H = 1).}
}
}
\description{
This function computes the probability distribution tables of Concordance Coefficient and Kruskal Wallis Statistic.
}
\section{Warning}{

The number of permutations increases rapidly with lenght (Sets). The computational time increases exponetianly with the number of elements and with the number of sets.
}

\examples{
Sample_Sizes <- c(5,4)
CT_Distribution(Sample_Sizes)
CT_Distribution(Sample_Sizes, H = 1)

CT_Distribution(c(3,3,3), H = 1)
}
