% Generated by roxygen2 (4.0.1): do not edit by hand
\name{condreg}
\alias{condreg}
\title{Compute the condition number with given penalty parameter}
\usage{
condreg(data_in, kmax)
}
\arguments{
\item{data_in}{input data}

\item{kmax}{scalar regularization parameter}
}
\value{
list of condition number regularized covariance matrix s
and its inverse invS.
}
\description{
Compute the condition number with given penalty parameter
}
\examples{
## True covariance matrix
sigma <- diag(5)
sigma[3,2] <- sigma[2,3] <- 0.8

## Generate normal random samples
\dontrun{
library(MASS)
X <- mvrnorm(200,rep(0,5),sigma)

## Covariance estimation
crcov <- condreg(X,3)

## Inspect output
str(crcov)              ## returned object
sigma.hat <- crcov$S    ## estimate of sigma matrix
omega.hat <- crcov$invS ## estimate of inverse of sigma matrix
}
}

