% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{ConnMatTools}
\alias{ConnMatTools}
\alias{ConnMatTools-package}
\title{Tools for working with connectivity matrices}
\description{
Tools for working with connectivity matrices
}
\details{
ConnMatTools collects several different methods for analyzing and
working with connectivity matrices in R.  Though primarily oriented
towards marine larval dispersal, many of the methods are general
and useful for terrestrial systems as well.

\tabular{ll}{
Package: \tab ConnMatTools\cr
Type: \tab Package\cr
Version: \tab 0.1.5\cr
Date: \tab 2013-07-09\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab no\cr
}
}
\examples{
\dontrun{optimalSplitConnMat(CM)}
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}

Marco Andrello \email{marco.andrello@gmail.com}
}
\references{
Jacobi, M. N., and Jonsson, P. R. 2011. Optimal networks of
  nature reserves can be found through eigenvalue perturbation theory of the
  connectivity matrix. Ecological Applications, 21: 1861-1870.

Jacobi, M. N., Andre, C., Doos, K., and Jonsson,
P. R. 2012. Identification of subpopulations from connectivity
matrices. Ecography, 35: 1004-1016.

Gruss, A., Kaplan, D. M., and Lett, C. 2012. Estimating local
  settler-recruit relationship parameters for complex spatially explicit
  models. Fisheries Research, 127-128: 34-39.

Kaplan, D. M., Botsford, L. W., and Jorgensen, S. 2006. Dispersal
  per recruit: An efficient method for assessing sustainability in marine
  reserve networks. Ecological Applications, 16: 2248-2263.

White, J. W. 2010. Adapting the steepness parameter from
  stock-recruit curves for use in spatially explicit models. Fisheries
  Research, 102: 330-334.

Gruss A, Kaplan DM, Hart DR (2011) Relative Impacts of Adult
  Movement, Larval Dispersal and Harvester Movement on the Effectiveness of
  Reserve Networks. PLoS ONE 6:e19960

Beverton RJH, Holt SJ (1957) On the dynamics of exploited fish
  populations. H.M.S.O., London. 533 pp.
}
\seealso{
See \code{\link{optimalSplitConnMat}}
}
\keyword{package}

